### Name: power.casectrl
### Title: Power for case-control genetics study
### Aliases: power.casectrl
### Keywords: design

### ** Examples


# single calc
power.casectrl(p=0.1, N=50, gamma=1.1, kp=.1, alpha=5e-2, minh='r')

# for a range of sample sizes
power.casectrl(p=0.1, N=c(25,50,100,200,500), gamma=1.1, kp=.1,
              alpha=5e-2, minh='r')

# create a power table
fun <- function(p)
  power.casectrl(p=p, N=seq(100,1000,by=100), gamma=1.1, kp=.1,
                alpha=5e-2, minh='recessive')

m <- sapply( X=seq(0.1,0.9, by=0.1), fun )
colnames(m) <- seq(0.1,0.9, by=0.1)
rownames(m) <- seq(100,1000,by=100)

print(round(m,2))



