### Name: gate.IPC
### Title: Interactive gating of an Image Parallel Coordinates Plot
### Aliases: gate.IPC
### Keywords: hplot

### ** Examples


if (require(rfcdmin)){
data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}

## make a smaller data for example
## first 1000 row observations
example.fcs<-unst.DRT[1:1000,]
if (!checkvars(example.fcs)){
example.fcs<-fixvars(example.fcs)
}

if (interactive()==TRUE){

## Joint parallel coordinates image
par(mfrow=c(4,3))
## gating the first column variable
## showing the image parallel coordinates
##    for column variables 1 through 5
gate.IPC(example.fcs, 1, var.pos=1:5, num.bins=10,joint=TRUE,
              title="Joint 10 bins 5 trans", ntrans=5)

## marginal parallel coordinate image
## gating the second column variable
par(mfrow=c(4,3))
gate.IPC(example.fcs, 2, var.pos=1:5, num.bins=10,joint=FALSE,
              title="Marginal 10 bins 5 trans", ntrans=5)
}
}




