### Name: fitmaanova
### Title: Fit ANOVA model for Micro Array experiment
### Aliases: fitmaanova
### Keywords: models

### ** Examples

###################################
# fixed model fitting
###################################
# load in Paigen's data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# Note that the data is normalized so normalization is skipped
# full model
model.full.fix <- makeModel(data=paigen,
      formula=~Dye+Array+Spot+Strain+Diet+Strain:Diet)
anova.full.fix <- fitmaanova(paigen, model.full.fix)
# residual plot
resiplot(paigen, anova.full.fix)

#######################################
# mixed model fitting -
# Array, Spot and biological
# replicates are random effects. 
# This may take a while to finish
#######################################
## Not run: 
##D model.full.mix <- makeModel(data=paigen,
##D       formula=~Dye+Array+Spot+Strain+Diet+Strain:Diet+Sample,
##D       random=~Array+Spot+Sample)
##D anova.full.mix <- fitmaanova(paigen, model.full.mix, method="REML")
##D # residual plot
##D resiplot(paigen, anova.full.mix)
##D # variance component plot
##D varplot(anova.full.mix)
## End(Not run)



