#!/usr/bin/perl

use strict;
use CGI;
use Symbol;

my $q = CGI::new();
my $tmpPath = "<<<STAM.TEMP.PATH>>>";

my $problems = '';
		      
# collect data needed
my $datapath   = $q->param('datapath');
my $toURL      = $q->param('toURL');

# verify consistency
if ($datapath eq "")             {$problems.=$q->li("No datapath defined");}
if (!(-e "$datapath/busy.html")) {$problems.=$q->li("busy.html in $datapath not found");}
if ($toURL eq "")                {$problems.=$q->li("No redirect URL defined");}

# report problem if any
if ($problems ne "") {
    print $q->header("text/html");
    print $q->start_html({-title=>"Remove busy.html",
			  -style=>{'src'=>'/includes/style.css'}});
    print $q->h1("Remove busy.html");
    print($q->p("The following problem(s) have been encountered:"),
	  $q->ul($problems));

    print($q->p("The following parameters have been received:"));
    my @parameters = $q->param();
    print "<UL>";
    foreach (@parameters) {
	print $q->li($_, " : ", $q->param($_));
    }
    print "</UL>";
    print $q->end_html();
    exit(0);
}

# write the table

my $handle = gensym();
my $filename = $tmpPath . time() . ".tab";
open($handle, ">$filename");
print $handle <<EndOfTable;
action\t"remove_busy.html"
data.path\t"$datapath"
EndOfTable
close($handle);

# redirect 
print($q->redirect($toURL));
exit(0);

#
#   end of file
#


