### Name: read.FCS
### Title: Reading in a raw binary Flow Cytometry Standard (FCS) file
### Aliases: read.FCS
### Keywords: classes character

### ** Examples


  if (require(rfcdmin)) {
    ## obtaining the location of the fcs files in the data

    FACSCAN256<- paste(system.file("fcs", package="rfcdmin"),
                            "facscan256.fcs",
                            sep="/")

    ## reading in the FCS files
    FCSobj1<-read.FCS(FACSCAN256)

    ## If a known type, then:
    ## read.FCS(fileName, fcs.type=foo)

    ## currently, the type doesn't have to be an argument
    ## the read.FCS function will check against different
    ## fcs.byte.size and fcs.signed options
    ## if the data is not the correct size or
    ## range as in the metadata
    ## NOTE: for FCS version 3.0 only
    ## the ranges NOT the sizes are checked
  }




