
##              G E N E R   
##               D E M O   

cat ("\n\n            G E N E R  \n             D E M O \n\n")

cat("\n------ First, play with character string !  -------\n")

s <- "gtcatgcatgctaggtgacagttaaaatgcgtctaggtgacagtctaacaa"

cat("\n------  Get the reverse complementary: -------\n")

strComp(s)

readline("Next")

cat("\n------ Insert a poly A into sequence -------\n")

s2 <- insertSeq(s,"aaaaaaaaaaaaaa",20) 
s2

cat("\n------ Count mono nucleotides, di-nucleotides !!! -------\n")

strCompoSeq(s2,wsize=1)

strCompoSeq(s2,wsize=2)

readline("Next")

cat ("\n------ Get some data from the web !! -------\n")

seqNcbi("BY608190",file='toto.fa')
readFasta('toto.fa')

readline("Next")

cat ("\n------ Now use functions with buffers -------\n")

cat ("\n------ Show current buffer -------\n")
getSeq()

readline("Next")

cat ("\n------ Extract from multiple positions (exons, introns...): -------\n")
getSeq(seqno=0,from=c(1,10,360),to=c(10,20,0))


readline("Next")

cat ("\n------ Look for motifs ------\n")

exactWord("AAAG",seqno=0)

readline("Next")

cat ("\n------ Find Orfs ------\n")

getOrfs(seqno=0)
maxOrf(seqno=0)

readline("Next")

cat ("\n------ Some tips on addresses ------\n")

s <- "xxxxxxxxxxATGTGTTAATAxxxxxxxxxxxxxxxxxxxx"
placeString(s)
writeFasta(file="toto.fa")
readFasta(file="toto.fa",from=11,to=20)
getSeq()

cat ("\n------ Orfs on 'Absolute' and 'relative' Adresses  ------\n")
getOrfs()
AtoT(getOrfs())

readline("Next")

cat ("\n------ More Fun !  ------\n")

getSeq()
exactWord(word="AA")
AtoT(exactWord(word="AA")[[1]])

readline("Ok ?")

setStrand(1)
getSeq()
exactWord(word="AA")
AtoT(exactWord(word="AA")[[1]])
exactWord(word="TT")
AtoT(exactWord(word="TT")[[1]])

## cat ("\n------ Compute intergenic region  ------\n")
## from <- c(1 ,25,75,100,150)
## to   <- c(30,50,120,110,170)

## cat ("\n imagine: from = genes$start, to=genes$stop\n")


## x <- unionSeg(data.frame(from,to))
## start <- x[,1]
## stop <- x[,2]
## n <- length(start)
## intergenes <-cbind(stop[1:n-1],start[2:n])
## intergenes

