### Name: bankDensityProfile
### Title: Computes density profile(s) of a bank of fasta sequences
### Aliases: bankDensityProfile
### Keywords: utilities

### ** Examples


  ## We create 2 banks
  for(i in 1:10)
  {
    s=randomSeq(n=100)
    placeString(s,seqno=0)
    writeFasta("toto_norm.fa",append=TRUE,name=i)

    s=randomSeq(prob=c(0.3,1,1,1,0)/3.3,n=100)
    placeString(s,seqno=0)
    writeFasta("toto_lowT.fa",append=TRUE,name=i)
  }

  densNorm <- bankDensityProfile("toto_norm.fa",nbin=10,sizeBin=10,allSeq=TRUE)
  densLowT <- bankDensityProfile("toto_lowT.fa",nbin=10,sizeBin=10,allSeq=TRUE)

  par(mfrow=c(1,2))
  ## Plot skew in normal bank
  plot(densNorm$skta,main="TA skew Normal bank",ylim=c(-0.8,0.3))

  ## Plot skew in low T bank
  plot(densLowT$skta,main="TA skew low T bank",ylim=c(-0.8,0.3))

  ## Show numbers
  densLowT



