### Name: MultiSet
### Title: Class to Contain and Describe High-Throughput Expression Level
###   Assays.
### Aliases: class:MultiSet MultiSet MultiSet-class
###   initialize,MultiSet-method
### Keywords: classes

### ** Examples

# create an instance of ExpressionSet
new("ExpressionSet")

# update existing exprSet-like class to ExpressionSet
data(sample.exprSet)
expressionSet <- as(sample.exprSet,"ExpressionSet")
expressionSet

# information about assay and sample data
featureNames(expressionSet)[1:10]
sampleNames(expressionSet)[1:5]
phenoData(expressionSet)
experimentData(expressionSet)

# subset: first 10 genes, samples 2, 4, and 10
expressionSet <- as(sample.exprSet,"ExpressionSet")
expressionSet[1:10,c(2,4,10)]

# named features and their expression levels
subset <- expressionSet[c("AFFX-BioC-3_at","AFFX-BioDn-5_at"),]
exprs(subset)

# samples with above-average 'score' in phenoData
highScores <- expressionSet$score > mean(expressionSet$score)
expressionSet[,highScores]



