### Name: comp.B
### Title: Computing B-statistics for Differential Expression
### Aliases: comp.B
### Keywords: univar

### ** Examples

X <- matrix(rnorm(1000,0,0.5), nc=10)
L <- rep(0:1,c(5,5))

# genes 1-10 are differentially expressed
X[1:10,6:10]<-X[1:10,6:10]+1

# compute B statistics, proportion set as 0.01
B.fun <- comp.B(L)
B.X <- B.fun(X)

# compute B statistics, proportion set as 0.1
B.fun <- comp.B(L, proportion=0.1)
B.X <- B.fun(X)

# Another way of computing B statistics
B.X<- comp.stat(X, L, "B")



