### Name: exprSet
### Title: Class for Microarray Data and Methods for Processing Them
### Aliases: exprSet class:exprSet as.data.frame.exprSet split write.exprs
###   update2MIAME exprs2excel
### Keywords: methods classes

### ** Examples

  data(geneData)
  data(geneCov)
  covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
  names(covdesc) <- names(geneCov)
  pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
  pdata[1,]
  pdata[,2]

  eset <- new("exprSet", exprs=geneData, phenoData=pdata)
  eset
  eset[,1:10]
  eset[,1]
  eset[1,]
  eset[1,1]
  eset[1:100,]
  eset[1:44,c(2,4,6)]
  Means <- iter(eset, f=mean)

  chkdich <- function(x) if(length(unique(x))!=2) stop("x not dichotomous")
  mytt <- function(x,y) {
     chkdich(x)
     d <- split(y,x)
     t.test(d[[1]],d[[2]])$p.val
  }

  Tpvals <- iter(eset, "cov1", mytt )

  sp1 <- split(eset, c(1,2))
  sp2 <- split(eset, c(rep(1,6), rep(2,7)))

  sampleNames(eset)
  sampleNames(eset) <- letters

  # as.data.frame.exprSet - example
  data(eset)
  sd.genes <- esApply(eset, 1, sd)
  dataf <- as.data.frame(eset)
  dataf <- cbind(dataf, sd.genes=rep(unname(sd.genes), length=nrow(dataf)))
  coplot(sd.genes ~ exprs | cov1+cov2, data=dataf)




