###################################################
### chunk number 1: preliminaries
###################################################
library(CMA)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## data(golub)
## golubY <- golub[,1]
## 
## golubX <- as.matrix(golub[,-1])
## 


###################################################
### chunk number 3:  eval=FALSE
###################################################
## 
## loodat <- GenerateLearningsets(y=golubY, method ="LOOCV")
## class(loodat)
## getSlots(class(loodat))
## show(loodat)
## 


###################################################
### chunk number 4:  eval=FALSE
###################################################
## 
## set.seed(321)
## fiveCVdat <- GenerateLearningsets(y=golubY, method = "CV", fold = 5, strat = TRUE)
## 
## 


###################################################
### chunk number 5:  eval=FALSE
###################################################
## 
## set.seed(456)
## MCCVdat <- GenerateLearningsets(y=golubY, method = "MCCV", niter = 3,
##                                 ntrain = floor(2/3*length(golubY)), strat = TRUE)
## 
## set.seed(651)
## bootdat <- GenerateLearningsets(y=golubY, method = "bootstrap", niter = 3, strat = TRUE)
##  
## 


###################################################
### chunk number 6:  eval=FALSE
###################################################
## 
## varsel_fiveCV <- GeneSelection(X = golubX, y=golubY, learningsets = fiveCVdat, method = "wilcox.test")
## varsel_MCCV <- GeneSelection(X = golubX, y=golubY, learningsets = MCCVdat, method = "wilcox.test")
## varsel_boot <- GeneSelection(X = golubX, y=golubY, learningsets = bootdat, method = "wilcox.test")
##  
## 


###################################################
### chunk number 7:  eval=FALSE
###################################################
## 
## show(varsel_fiveCV)
## toplist(varsel_fiveCV, iter=1)
## seliter <- numeric()
## for(i in 1:5)
## seliter <- c(seliter, toplist(varsel_fiveCV, iter = i, top = 10, show = FALSE)$index)
## sort(table(seliter), dec = TRUE)
## 


###################################################
### chunk number 8:  eval=FALSE
###################################################
## set.seed(351) 
## tuningstep <- CMA:::tune(X = golubX, y=golubY, learningsets = fiveCVdat,
##                       genesel = varsel_fiveCV, nbgene = 100, classifier = svmCMA,
##                       grids = list(cost = c(0.1, 1, 10, 100, 200)))
## 


###################################################
### chunk number 9:  eval=FALSE
###################################################
##                       
## show(tuningstep)
## unlist(best(tuningstep))
## 


###################################################
### chunk number 10:  eval=FALSE
###################################################
## 
## par(mfrow = c(2,2))
## for(i in 1:4)
## plot(tuningstep, iter = i, main = paste("iteration", i))


###################################################
### chunk number 11:  eval=FALSE
###################################################
## 
## #class_loo <- classification(X = golubX, y=golubY, learningsets = loodat,
## #                      genesel = varsel_loo, nbgene = 100, classifier = svmCMA,
## #                      cost = 100)
##                       
## class_fiveCV <- classification(X = golubX, y=golubY, learningsets = fiveCVdat,
##                       genesel = varsel_fiveCV, nbgene = 100, classifier = svmCMA,
##                       cost = 100)
##                       
## class_MCCV <- classification(X = golubX, y=golubY, learningsets = MCCVdat,
##                       genesel = varsel_MCCV, nbgene = 100, classifier = svmCMA,
##                       cost = 100)
##                       
## class_boot <- classification(X = golubX, y=golubY, learningsets = bootdat,
##                       genesel = varsel_boot, nbgene = 100, classifier = svmCMA,
##                       cost = 100)
##                       
## 


###################################################
### chunk number 12:  eval=FALSE
###################################################
## 
## resultlist <- list(class_fiveCV, class_MCCV, class_boot)
## result <- lapply(resultlist, join)
## 


###################################################
### chunk number 13:  eval=FALSE
###################################################
## 
## 
## schemes <- c("five-fold CV", "MCCV", "bootstrap")
## 
## par(mfrow = c(3,1))
## for(i in seq(along = result))
##  plot(result[[i]], main = schemes[i])
## 


###################################################
### chunk number 14:  eval=FALSE
###################################################
## 
## invisible(lapply(result, ftable))
## 


###################################################
### chunk number 15:  eval=FALSE
###################################################
## 
## par(mfrow = c(2,2))
## for(i in seq(along = result)) roc(result[[i]])
## 


###################################################
### chunk number 16:  eval=FALSE
###################################################
## 
## totalresult <- join(result)
## ftable(totalresult)
## 


###################################################
### chunk number 17:  eval=FALSE
###################################################
## 
## av_MCCV <- evaluation(class_MCCV, measure = "average probability")
## show(av_MCCV)
## boxplot(av_MCCV)
## summary(av_MCCV)
## 


###################################################
### chunk number 18:  eval=FALSE
###################################################
## av_obs_MCCV <- evaluation(class_MCCV, measure = "average probability", scheme = "obs")
## show(av_obs_MCCV)
## 


###################################################
### chunk number 19:  eval=FALSE
###################################################
## 
## obsinfo(av_obs_MCCV, threshold = 0.6)
## 


###################################################
### chunk number 20: 
###################################################

data(khan)
khanY <- khan[,1]
khanX <- as.matrix(khan[,-1])


set.seed(27611)
fiveCV5iter <- GenerateLearningsets(y=khanY, method = "CV", fold = 5, niter = 5, strat = TRUE)




###################################################
### chunk number 21: 
###################################################

class_dlda <- classification(X = khanX, y=khanY, learningsets = fiveCV5iter,
                             classifier = dldaCMA)
                             



###################################################
### chunk number 22: 
###################################################


genesel_da <- GeneSelection(X=khanX, y=khanY, learningsets = fiveCV5iter,
                            method = "t.test", scheme = "one-vs-all")



###################################################
### chunk number 23: 
###################################################

class_lda <- classification(X = khanX, y=khanY, learningsets = fiveCV5iter,
                             classifier = ldaCMA, genesel= genesel_da,
                             nbgene = 10)
                             
class_fda <- classification(X = khanX, y=khanY, learningsets = fiveCV5iter,
                             classifier = fdaCMA, genesel = genesel_da,
                             nbgene = 10, comp = 2)
                             
class_qda <- classification(X = khanX, y=khanY, learningsets = fiveCV5iter,
                             classifier = qdaCMA, genesel = genesel_da,
                             nbgene = 1)
                             


###################################################
### chunk number 24: 
###################################################

set.seed(876)
class_scda <- classification(X = khanX, y=khanY, learningsets = fiveCV5iter,
                             classifier = scdaCMA, tuninglist = list(grids = list()))



###################################################
### chunk number 25: 
###################################################

class_plsda <- classification(X = khanX, y=khanY, learningsets = fiveCV5iter,
                             classifier = pls_ldaCMA)



###################################################
### chunk number 26: 
###################################################
                             
dalike <- list(class_dlda, class_lda, class_fda, class_qda, class_scda, class_plsda)
par(mfrow = c(3,1))
comparison <- compare(dalike, plot = TRUE, measure = c("misclassification", "brier score", "average probability"))
print(comparison)
                      


