### Name: aCGH.read.Sprocs
### Title: Create object of class "aCGH" from Sproc files
### Aliases: aCGH.read.Sprocs dotify.names read.Sproc.files
###   extract.clones.info
### Keywords: file

### ** Examples


datadir <- system.file("examples", package = "aCGH")
latest.mapping.file <-
      file.path(datadir, "human.clones.info.Jul03.txt")
ex.acgh <-
        aCGH.read.Sprocs(dir(path = datadir,pattern = "sproc",
                        full.names = TRUE), latest.mapping.file,
                        chrom.remove.threshold = 23)
ex.acgh

## Testing if creating the object went right. Should all be true.

all(log2.ratios(ex.acgh)[ 1, ] == c(-0.077698 , 0.007389))
clone.name <- "HumArray2H10_T30"
all(log2.ratios(ex.acgh)[ clone.name, ] == c(0.025567 , -0.036908))




