/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    protected int[] parse(String str) throws SchemaDateTimeException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        date[0] = 2000;
        if (str.charAt(0) != '-' || str.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str);
        }
        date[1] = this.parseInt(str, 2, 4);
        int start = 4;
        if (str.charAt(start++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str);
        }
        date[2] = this.parseInt(str, start, start + 2);
        if (7 < len) {
            int sign = this.findUTCSign(str, 7, len);
            if (sign < 0) {
                throw new SchemaDateTimeException("Error in month parsing:" + str);
            }
            this.getTimeZone(str, date, sign, len, timeZone);
        }
        this.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            this.normalize(date, timeZone);
        }
        return date;
    }

    protected String dateToString(int[] date) {
        StringBuffer message = new StringBuffer(8);
        message.append('-');
        message.append('-');
        this.append(message, date[1], 2);
        message.append('-');
        this.append(message, date[2], 2);
        this.append(message, (char)date[7], 0);
        return message.toString();
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return new AbstractDateTimeDV.DateTimeData(this.parse(content), this);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gMonthDay"});
        }
    }
}

