/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLCollectionImpl;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.apache.html.dom.HTMLTableCaptionElementImpl;
import org.apache.html.dom.HTMLTableRowElementImpl;
import org.apache.html.dom.HTMLTableSectionElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCaptionElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableElementImpl
extends HTMLElementImpl
implements HTMLTableElement {
    private HTMLCollectionImpl _rows;
    private HTMLCollectionImpl _bodies;

    public synchronized void deleteCaption() {
        HTMLTableCaptionElement old = this.getCaption();
        if (old != null) {
            this.removeChild(old);
        }
    }

    public synchronized void deleteTFoot() {
        HTMLTableSectionElement old = this.getTFoot();
        if (old != null) {
            this.removeChild(old);
        }
    }

    public synchronized void deleteTHead() {
        HTMLTableSectionElement old = this.getTHead();
        if (old != null) {
            this.removeChild(old);
        }
    }

    public synchronized void deleteRow(int index) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableRowElement) {
                if (index == 0) {
                    this.removeChild(child);
                    return;
                }
            } else if (child instanceof HTMLTableSectionElementImpl && (index = ((HTMLTableSectionElementImpl)child).deleteRowX(index)) < 0) {
                return;
            }
            child = child.getNextSibling();
        }
    }

    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    public String getFrame() {
        return this.capitalize(this.getAttribute("frame"));
    }

    public String getRules() {
        return this.capitalize(this.getAttribute("rules"));
    }

    public String getSummary() {
        return this.getAttribute("summary");
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    public void setCellPadding(String cellPadding) {
        this.setAttribute("cellpadding", cellPadding);
    }

    public void setCellSpacing(String cellSpacing) {
        this.setAttribute("cellspacing", cellSpacing);
    }

    public void setFrame(String frame) {
        this.setAttribute("frame", frame);
    }

    public void setRules(String rules) {
        this.setAttribute("rules", rules);
    }

    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    void insertRowX(int index, HTMLTableRowElementImpl newRow) {
        Node lastSection = null;
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableRowElement) {
                if (index == 0) {
                    this.insertBefore(newRow, child);
                    return;
                }
            } else if (child instanceof HTMLTableSectionElementImpl) {
                lastSection = child;
                if ((index = ((HTMLTableSectionElementImpl)child).insertRowX(index, newRow)) < 0) {
                    return;
                }
            }
            child = child.getNextSibling();
        }
        if (lastSection != null) {
            lastSection.appendChild(newRow);
        } else {
            this.appendChild(newRow);
        }
    }

    public HTMLCollection getRows() {
        if (this._rows == null) {
            this._rows = new HTMLCollectionImpl(this, 7);
        }
        return this._rows;
    }

    public HTMLCollection getTBodies() {
        if (this._bodies == null) {
            this._bodies = new HTMLCollectionImpl(this, -2);
        }
        return this._bodies;
    }

    public synchronized HTMLElement createCaption() {
        HTMLTableCaptionElement section = this.getCaption();
        if (section != null) {
            return section;
        }
        section = new HTMLTableCaptionElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "CAPTION");
        this.appendChild(section);
        return section;
    }

    public synchronized HTMLElement createTFoot() {
        HTMLTableSectionElement section = this.getTFoot();
        if (section != null) {
            return section;
        }
        section = new HTMLTableSectionElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TFOOT");
        this.appendChild(section);
        return section;
    }

    public synchronized HTMLElement createTHead() {
        HTMLTableSectionElement section = this.getTHead();
        if (section != null) {
            return section;
        }
        section = new HTMLTableSectionElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "THEAD");
        this.appendChild(section);
        return section;
    }

    public HTMLElement insertRow(int index) {
        HTMLTableRowElementImpl newRow = new HTMLTableRowElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TR");
        this.insertRowX(index, newRow);
        return newRow;
    }

    public synchronized HTMLTableCaptionElement getCaption() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableCaptionElement && child.getNodeName().equals("CAPTION")) {
                return (HTMLTableCaptionElement)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public synchronized void setCaption(HTMLTableCaptionElement caption) {
        if (caption != null && !caption.getTagName().equals("CAPTION")) {
            throw new IllegalArgumentException("HTM016 Argument 'caption' is not an element of type <CAPTION>.");
        }
        this.deleteCaption();
        if (caption != null) {
            this.appendChild(caption);
        }
    }

    public synchronized HTMLTableSectionElement getTFoot() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableSectionElement && child.getNodeName().equals("TFOOT")) {
                return (HTMLTableSectionElement)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public synchronized HTMLTableSectionElement getTHead() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableSectionElement && child.getNodeName().equals("THEAD")) {
                return (HTMLTableSectionElement)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public synchronized void setTFoot(HTMLTableSectionElement tFoot) {
        if (tFoot != null && !tFoot.getTagName().equals("TFOOT")) {
            throw new IllegalArgumentException("HTM018 Argument 'tFoot' is not an element of type <TFOOT>.");
        }
        this.deleteTFoot();
        if (tFoot != null) {
            this.appendChild(tFoot);
        }
    }

    public synchronized void setTHead(HTMLTableSectionElement tHead) {
        if (tHead != null && !tHead.getTagName().equals("THEAD")) {
            throw new IllegalArgumentException("HTM017 Argument 'tHead' is not an element of type <THEAD>.");
        }
        this.deleteTHead();
        if (tHead != null) {
            this.appendChild(tHead);
        }
    }

    public HTMLTableElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

