/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Array;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioMaterial.BioMaterial;
import org.biomage.Common.Describable;
import org.biomage.Description.DatabaseEntry;
import org.biomage.DesignElement.Feature;
import org.biomage.Interface.HasBioMaterial;
import org.biomage.Interface.HasFeature;
import org.biomage.Interface.HasIdentifierLIMS;
import org.xml.sax.Attributes;

public class ManufactureLIMS
extends Describable
implements Serializable,
HasFeature,
HasIdentifierLIMS,
HasBioMaterial {
    String quality;
    protected Feature feature;
    protected BioMaterial bioMaterial;
    protected DatabaseEntry identifierLIMS;

    public ManufactureLIMS() {
    }

    public ManufactureLIMS(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "quality");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.quality = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<ManufactureLIMS");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</ManufactureLIMS>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.quality != null) {
            out.write(" quality=\"" + this.quality + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.feature != null) {
            out.write("<Feature_assnref>");
            out.write("<" + this.feature.getModelClassName() + "_ref identifier=\"" + this.feature.getIdentifier() + "\"/>");
            out.write("</Feature_assnref>");
        }
        if (this.bioMaterial != null) {
            out.write("<BioMaterial_assnref>");
            out.write("<" + this.bioMaterial.getModelClassName() + "_ref identifier=\"" + this.bioMaterial.getIdentifier() + "\"/>");
            out.write("</BioMaterial_assnref>");
        }
        if (this.identifierLIMS != null) {
            out.write("<IdentifierLIMS_assn>");
            this.identifierLIMS.writeMAGEML(out);
            out.write("</IdentifierLIMS_assn>");
        }
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getQuality() {
        return this.quality;
    }

    public String getModelClassName() {
        return new String("ManufactureLIMS");
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setBioMaterial(BioMaterial bioMaterial) {
        this.bioMaterial = bioMaterial;
    }

    public BioMaterial getBioMaterial() {
        return this.bioMaterial;
    }

    public void setIdentifierLIMS(DatabaseEntry identifierLIMS) {
        this.identifierLIMS = identifierLIMS;
    }

    public DatabaseEntry getIdentifierLIMS() {
        return this.identifierLIMS;
    }
}

