### Name: imageMap-methods
### Title: Write an HTML IMG tag together with a MAP image map.
### Aliases: imageMap imageMap-methods imageMap,matrix-method
###   imageMap,matrix,connection,list,character-method
### Keywords: manip

### ** Examples

fhtml  <- tempfile()
fpng   <- tempfile()

if(capabilities()["png"] && interactive()) {
  width <- height <- 512
  png(fpng, width=width, height=height)
  par(mai=rep(0,4))
  plot(0, xlim=c(0, width-1), ylim=c(0, height-1), xaxs="i", yaxs="i",
       type="n")
  coord=cbind(c(100,360),c(400, 50),c(200,460),c(500,150))
  rect(coord[,1], height-coord[,2], coord[,3], height-coord[,4], col=c("#1f77b4", "#b2df8a"))
  dev.off()

  con <- openHtmlPage(fhtml, "Hello world")
  imageMap(con, fpng, coord=coord, 
    url=paste("http://", c("link1", "link2"), sep=""),
    tooltips=c("Blue box", "Green box"))
  closeHtmlPage(con)

  cat("Now have a look at file ", fhtml, ".html with your browser.\n", sep="")
}



