/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.apache.xalan.xsltc.runtime.output.StreamHTMLOutput;
import org.apache.xalan.xsltc.runtime.output.StreamOutput;
import org.apache.xalan.xsltc.runtime.output.StreamXMLOutput;

public class StreamUnknownOutput
extends StreamOutput {
    private StreamOutput _handler;
    private boolean _isHtmlOutput = false;
    private boolean _firstTagOpen = false;
    private boolean _firstElement = true;
    private String _firstTagPrefix;
    private String _firstTag;
    private ArrayList _attributes = null;
    private ArrayList _namespaces = null;
    private String _mediaType = null;
    private boolean _callStartDocument = false;
    private boolean _callSetVersion = false;
    private boolean _callSetDoctype = false;

    public StreamUnknownOutput(Writer writer, String encoding) {
        super(writer, encoding);
        this._handler = new StreamXMLOutput(writer, encoding);
    }

    public StreamUnknownOutput(OutputStream out, String encoding) throws IOException {
        super(out, encoding);
        this._handler = new StreamXMLOutput(out, encoding);
    }

    public void startDocument() throws TransletException {
        this._callStartDocument = true;
    }

    public void endDocument() throws TransletException {
        if (this._firstTagOpen) {
            this.initStreamOutput();
        } else if (this._callStartDocument) {
            this._handler.startDocument();
        }
        this._handler.endDocument();
    }

    public void startElement(String elementName) throws TransletException {
        if (this._firstElement) {
            this._firstElement = false;
            this._firstTag = elementName;
            this._firstTagPrefix = BasisLibrary.getPrefix(elementName);
            if (this._firstTagPrefix == null) {
                this._firstTagPrefix = "";
            }
            this._firstTagOpen = true;
            this._isHtmlOutput = BasisLibrary.getLocalName(elementName).equalsIgnoreCase("html");
        } else {
            if (this._firstTagOpen) {
                this.initStreamOutput();
            }
            this._handler.startElement(elementName);
        }
    }

    public void endElement(String elementName) throws TransletException {
        if (this._firstTagOpen) {
            this.initStreamOutput();
        }
        this._handler.endElement(elementName);
    }

    public void characters(String characters) throws TransletException {
        if (this._firstTagOpen) {
            this.initStreamOutput();
        }
        this._handler.characters(characters);
    }

    public void characters(char[] characters, int offset, int length) throws TransletException {
        if (this._firstTagOpen) {
            this.initStreamOutput();
        }
        this._handler.characters(characters, offset, length);
    }

    public void attribute(String name, String value) throws TransletException {
        if (this._firstTagOpen) {
            if (this._attributes == null) {
                this._attributes = new ArrayList();
            }
            this._attributes.add(new Pair(name, value));
        } else {
            this._handler.attribute(name, value);
        }
    }

    public void namespace(String prefix, String uri) throws TransletException {
        if (this._firstTagOpen) {
            if (this._namespaces == null) {
                this._namespaces = new ArrayList();
            }
            this._namespaces.add(new Pair(prefix, uri));
            if (this._firstTagPrefix.equals(prefix) && !uri.equals("")) {
                this._isHtmlOutput = false;
            }
        } else {
            this._handler.namespace(prefix, uri);
        }
    }

    public void comment(String comment) throws TransletException {
        if (this._firstTagOpen) {
            this.initStreamOutput();
        }
        this._handler.comment(comment);
    }

    public void processingInstruction(String target, String data) throws TransletException {
        if (this._firstTagOpen) {
            this.initStreamOutput();
        }
        this._handler.processingInstruction(target, data);
    }

    public void setDoctype(String system, String pub) {
        this._handler.setDoctype(system, pub);
        super.setDoctype(system, pub);
        this._callSetDoctype = true;
    }

    public void setIndent(boolean indent) {
        this._handler.setIndent(indent);
    }

    public void setVersion(String version2) {
        this._handler.setVersion(version2);
        super.setVersion(version2);
        this._callSetVersion = true;
    }

    public void omitHeader(boolean value) {
        this._handler.omitHeader(value);
    }

    public void setStandalone(String standalone) {
        this._handler.setStandalone(standalone);
    }

    public void setMediaType(String mediaType) {
        this._handler.setMediaType(mediaType);
        this._mediaType = mediaType;
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        return this._handler.setEscaping(escape);
    }

    public void setCdataElements(Hashtable elements) {
        this._handler.setCdataElements(elements);
    }

    public void setIndentNumber(int value) {
        this._handler.setIndentNumber(value);
    }

    private void initStreamOutput() throws TransletException {
        Pair pair;
        int i;
        int n;
        if (this._isHtmlOutput) {
            this._handler = new StreamHTMLOutput(this._handler);
            if (this._callSetVersion) {
                this._handler.setVersion(this._version);
            }
            if (this._callSetDoctype) {
                this._handler.setDoctype(this._doctypeSystem, this._doctypePublic);
            }
            if (this._mediaType != null) {
                this._handler.setMediaType(this._mediaType);
            }
        }
        if (this._callStartDocument) {
            this._handler.startDocument();
            this._callStartDocument = false;
        }
        this._handler.startElement(this._firstTag);
        if (this._namespaces != null) {
            n = this._namespaces.size();
            i = 0;
            while (i < n) {
                pair = (Pair)this._namespaces.get(i);
                this._handler.namespace(pair.name, pair.value);
                ++i;
            }
        }
        if (this._attributes != null) {
            n = this._attributes.size();
            i = 0;
            while (i < n) {
                pair = (Pair)this._attributes.get(i);
                this._handler.attribute(pair.name, pair.value);
                ++i;
            }
        }
        this._firstTagOpen = false;
    }

    static class Pair {
        public String name;
        public String value;

        public Pair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

