/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.regexp.RECompiler;

public class REDebugCompiler
extends RECompiler {
    static Hashtable hashOpcode = new Hashtable();

    String opcodeToString(char opcode) {
        String ret = (String)hashOpcode.get(new Integer(opcode));
        if (ret == null) {
            ret = "OP_????";
        }
        return ret;
    }

    String charToString(char c) {
        if (c < ' ' || c > '\u007f') {
            return "\\" + c;
        }
        return String.valueOf(c);
    }

    String nodeToString(int node) {
        char opcode = this.instruction[node + 0];
        char opdata = this.instruction[node + 1];
        return this.opcodeToString(opcode) + ", opdata = " + opdata;
    }

    public void dumpProgram(PrintWriter p) {
        int i = 0;
        while (i < this.lenInstruction) {
            char opcode = this.instruction[i + 0];
            int opdata = this.instruction[i + 1];
            short next = (short)this.instruction[i + 2];
            p.print(i + ". " + this.nodeToString(i) + ", next = ");
            if (next == 0) {
                p.print("none");
            } else {
                p.print(i + next);
            }
            i += 3;
            if (opcode == '[') {
                p.print(", [");
                int rangeCount = opdata;
                int r = 0;
                while (r < rangeCount) {
                    char charLast;
                    char charFirst;
                    if ((charFirst = this.instruction[i++]) == (charLast = this.instruction[i++])) {
                        p.print(this.charToString(charFirst));
                    } else {
                        p.print(this.charToString(charFirst) + "-" + this.charToString(charLast));
                    }
                    ++r;
                }
                p.print("]");
            }
            if (opcode == 'A') {
                p.print(", \"");
                int len = opdata;
                while (len-- != 0) {
                    p.print(this.charToString(this.instruction[i++]));
                }
                p.print("\"");
            }
            p.println("");
        }
    }

    static {
        hashOpcode.put(new Integer(56), "OP_RELUCTANTSTAR");
        hashOpcode.put(new Integer(61), "OP_RELUCTANTPLUS");
        hashOpcode.put(new Integer(47), "OP_RELUCTANTMAYBE");
        hashOpcode.put(new Integer(69), "OP_END");
        hashOpcode.put(new Integer(94), "OP_BOL");
        hashOpcode.put(new Integer(36), "OP_EOL");
        hashOpcode.put(new Integer(46), "OP_ANY");
        hashOpcode.put(new Integer(91), "OP_ANYOF");
        hashOpcode.put(new Integer(124), "OP_BRANCH");
        hashOpcode.put(new Integer(65), "OP_ATOM");
        hashOpcode.put(new Integer(42), "OP_STAR");
        hashOpcode.put(new Integer(43), "OP_PLUS");
        hashOpcode.put(new Integer(63), "OP_MAYBE");
        hashOpcode.put(new Integer(78), "OP_NOTHING");
        hashOpcode.put(new Integer(71), "OP_GOTO");
        hashOpcode.put(new Integer(92), "OP_ESCAPE");
        hashOpcode.put(new Integer(40), "OP_OPEN");
        hashOpcode.put(new Integer(41), "OP_CLOSE");
        hashOpcode.put(new Integer(35), "OP_BACKREF");
        hashOpcode.put(new Integer(80), "OP_POSIXCLASS");
    }
}

