/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class YearMonthDV
extends AbstractDateTimeDV {
    protected int[] parse(String str) throws SchemaDateTimeException {
        int len = str.length();
        int[] date = new int[8];
        int[] timeZone = new int[2];
        int end = this.getYearMonth(str, 0, len, date);
        date[2] = 15;
        this.parseTimeZone(str, end, len, date, timeZone);
        this.validateDateTime(date, timeZone);
        if (date[7] != 0 && date[7] != 90) {
            this.normalize(date, timeZone);
        }
        return date;
    }

    protected String dateToString(int[] date) {
        StringBuffer message = new StringBuffer(25);
        this.append(message, date[0], 4);
        message.append('-');
        this.append(message, date[1], 2);
        this.append(message, (char)date[7], 0);
        return message.toString();
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return new AbstractDateTimeDV.DateTimeData(this.parse(content), this);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gYearMonth"});
        }
    }
}

