/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.tools.xmlutils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biomage.tools.xmlutils.MultiMap;

public class MultiHashtable
extends Hashtable
implements MultiMap {
    public MultiHashtable() {
    }

    public MultiHashtable(int initial_capacity) {
        super(initial_capacity);
    }

    public MultiHashtable(int initial_capacity, float load_factor) {
        super(initial_capacity, load_factor);
    }

    public MultiHashtable(MultiHashtable copy_from) {
        super(copy_from);
    }

    public MultiHashtable(MultiMap copy_from) {
        throw new UnsupportedOperationException("You'll have to add a constructor to MultiHashtable.java to copy from the MultiMap type you've given, since we've no way know how you've implemented it.");
    }

    public MultiHashtable(Map copy_from) {
        Iterator keys = this.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object val = copy_from.get(key);
            if (val == null) continue;
            this.put(key, val);
        }
    }

    public boolean containsValue(Object value) {
        Iterator keys = this.keySet().iterator();
        while (keys.hasNext()) {
            if (!((Set)keys.next()).contains(value)) continue;
            return true;
        }
        if (value instanceof Set) {
            return super.containsValue(value);
        }
        return false;
    }

    public Object put(Object key, Object value) {
        Set values_set = null;
        if (this.containsKey(key)) {
            values_set = (Set)this.get(key);
        } else {
            values_set = this.createValuesSet();
            super.put(key, values_set);
        }
        values_set.add(value);
        return null;
    }

    public boolean removeAll(Object obj) {
        Iterator keys = this.keySet().iterator();
        boolean anything_removed = false;
        while (keys.hasNext()) {
            Set values_set = (Set)this.get(keys.next());
            anything_removed |= values_set.remove(obj);
        }
        return anything_removed |= this.remove(obj) != null;
    }

    public Collection values() {
        Iterator values_sets_iterator = this.valuesSets().iterator();
        HashSet values = null;
        while (values_sets_iterator.hasNext()) {
            Set values_set = (Set)values_sets_iterator.next();
            if (values_set.isEmpty()) continue;
            if (values == null) {
                values = new HashSet(values_set.size());
            }
            values.addAll(values_set);
        }
        return values;
    }

    public Object remove(Object key, Object value) {
        Set values_set = (Set)this.get(key);
        if (values_set == null) {
            return null;
        }
        if (values_set.remove(value)) {
            return value;
        }
        return null;
    }

    public Collection valuesSets() {
        return super.values();
    }

    protected Set createValuesSet() {
        return Collections.synchronizedSet(new HashSet(1));
    }
}

