/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.biomage.Interface.HasSoftware;
import org.biomage.Protocol.ParameterizableApplication;
import org.biomage.Protocol.Software;
import org.xml.sax.Attributes;

public class SoftwareApplication
extends ParameterizableApplication
implements Serializable,
HasSoftware {
    String version;
    Date releaseDate;
    protected Software software;

    public SoftwareApplication() {
    }

    public SoftwareApplication(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "version");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.version = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "releaseDate")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            try {
                this.releaseDate = new SimpleDateFormat("yyyy-MM-dd").parse(atts.getValue(nIndex));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<SoftwareApplication");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</SoftwareApplication>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.version != null) {
            out.write(" version=\"" + this.version + "\"");
        }
        if (this.releaseDate != null) {
            out.write(" releaseDate=\"" + this.releaseDate + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.software != null) {
            out.write("<Software_assnref>");
            out.write("<" + this.software.getModelClassName() + "_ref identifier=\"" + this.software.getIdentifier() + "\"/>");
            out.write("</Software_assnref>");
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String getModelClassName() {
        return new String("SoftwareApplication");
    }

    public void setSoftware(Software software) {
        this.software = software;
    }

    public Software getSoftware() {
        return this.software;
    }
}

