/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Description;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Common.Extendable;
import org.biomage.Description.Database;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasDatabase;
import org.biomage.Interface.HasType;
import org.xml.sax.Attributes;

public class DatabaseEntry
extends Extendable
implements Serializable,
HasDatabase,
HasType {
    String accession;
    String accessionVersion;
    String URI;
    protected OntologyEntry type;
    protected Database database;

    public DatabaseEntry() {
    }

    public DatabaseEntry(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "accession");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.accession = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "accessionVersion")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.accessionVersion = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "URI")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.URI = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<DatabaseEntry");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</DatabaseEntry>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.accession != null) {
            out.write(" accession=\"" + this.accession + "\"");
        }
        if (this.accessionVersion != null) {
            out.write(" accessionVersion=\"" + this.accessionVersion + "\"");
        }
        if (this.URI != null) {
            out.write(" URI=\"" + this.URI + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.type != null) {
            out.write("<Type_assn>");
            this.type.writeMAGEML(out);
            out.write("</Type_assn>");
        }
        if (this.database != null) {
            out.write("<Database_assnref>");
            out.write("<" + this.database.getModelClassName() + "_ref identifier=\"" + this.database.getIdentifier() + "\"/>");
            out.write("</Database_assnref>");
        }
    }

    public void setAccession(String accession) {
        this.accession = accession;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setAccessionVersion(String accessionVersion) {
        this.accessionVersion = accessionVersion;
    }

    public String getAccessionVersion() {
        return this.accessionVersion;
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public String getURI() {
        return this.URI;
    }

    public String getModelClassName() {
        return new String("DatabaseEntry");
    }

    public void setType(OntologyEntry type) {
        this.type = type;
    }

    public OntologyEntry getType() {
        return this.type;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }
}

