/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.ArrayDesign;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Common.Identifiable;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasSpecies;
import org.biomage.Interface.HasTypes;
import org.xml.sax.Attributes;

public abstract class DesignElementGroup
extends Identifiable
implements Serializable,
HasSpecies,
HasTypes {
    protected HasTypes.Types_list types = new HasTypes.Types_list();
    protected OntologyEntry species;

    public DesignElementGroup() {
    }

    public DesignElementGroup(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.types.size() > 0) {
            out.write("<Types_assnlist>");
            for (int i = 0; i < this.types.size(); ++i) {
                ((OntologyEntry)this.types.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Types_assnlist>");
        }
        if (this.species != null) {
            out.write("<Species_assn>");
            this.species.writeMAGEML(out);
            out.write("</Species_assn>");
        }
    }

    public String getModelClassName() {
        return new String("DesignElementGroup");
    }

    public void setTypes(HasTypes.Types_list types) {
        this.types = types;
    }

    public HasTypes.Types_list getTypes() {
        return this.types;
    }

    public void addToTypes(OntologyEntry ontologyEntry) {
        this.types.add(ontologyEntry);
    }

    public void addToTypes(int position, OntologyEntry ontologyEntry) {
        this.types.add(position, ontologyEntry);
    }

    public OntologyEntry getFromTypes(int position) {
        return (OntologyEntry)this.types.get(position);
    }

    public void removeElementAtFromTypes(int position) {
        this.types.removeElementAt(position);
    }

    public void removeFromTypes(OntologyEntry ontologyEntry) {
        this.types.remove(ontologyEntry);
    }

    public void setSpecies(OntologyEntry species) {
        this.species = species;
    }

    public OntologyEntry getSpecies() {
        return this.species;
    }
}

