/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.ArrayDesign;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.ArrayDesign.CompositeGroup;
import org.biomage.ArrayDesign.FeatureGroup;
import org.biomage.ArrayDesign.ReporterGroup;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.Common.Identifiable;
import org.biomage.Interface.HasCompositeGroups;
import org.biomage.Interface.HasDesignProviders;
import org.biomage.Interface.HasFeatureGroups;
import org.biomage.Interface.HasProtocolApplications;
import org.biomage.Interface.HasReporterGroups;
import org.biomage.Protocol.ProtocolApplication;
import org.xml.sax.Attributes;

public class ArrayDesign
extends Identifiable
implements Serializable,
HasProtocolApplications,
HasCompositeGroups,
HasDesignProviders,
HasReporterGroups,
HasFeatureGroups {
    String version;
    Integer numberOfFeatures;
    protected HasProtocolApplications.ProtocolApplications_list protocolApplications = new HasProtocolApplications.ProtocolApplications_list();
    protected HasFeatureGroups.FeatureGroups_list featureGroups = new HasFeatureGroups.FeatureGroups_list();
    protected HasReporterGroups.ReporterGroups_list reporterGroups = new HasReporterGroups.ReporterGroups_list();
    protected HasCompositeGroups.CompositeGroups_list compositeGroups = new HasCompositeGroups.CompositeGroups_list();
    protected HasDesignProviders.DesignProviders_list designProviders = new HasDesignProviders.DesignProviders_list();

    public ArrayDesign() {
    }

    public ArrayDesign(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "version");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.version = atts.getValue(nIndex);
        }
        if ((nIndex = atts.getIndex("", "numberOfFeatures")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.numberOfFeatures = new Integer(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<ArrayDesign");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</ArrayDesign>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.version != null) {
            out.write(" version=\"" + this.version + "\"");
        }
        if (this.numberOfFeatures != null) {
            out.write(" numberOfFeatures=\"" + this.numberOfFeatures + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        String modelClassName;
        int i;
        super.writeAssociations(out);
        if (this.protocolApplications.size() > 0) {
            out.write("<ProtocolApplications_assnlist>");
            for (i = 0; i < this.protocolApplications.size(); ++i) {
                ((ProtocolApplication)this.protocolApplications.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ProtocolApplications_assnlist>");
        }
        if (this.featureGroups.size() > 0) {
            out.write("<FeatureGroups_assnlist>");
            for (i = 0; i < this.featureGroups.size(); ++i) {
                ((FeatureGroup)this.featureGroups.elementAt(i)).writeMAGEML(out);
            }
            out.write("</FeatureGroups_assnlist>");
        }
        if (this.reporterGroups.size() > 0) {
            out.write("<ReporterGroups_assnreflist>");
            for (i = 0; i < this.reporterGroups.size(); ++i) {
                modelClassName = ((ReporterGroup)this.reporterGroups.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((ReporterGroup)this.reporterGroups.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</ReporterGroups_assnreflist>");
        }
        if (this.compositeGroups.size() > 0) {
            out.write("<CompositeGroups_assnreflist>");
            for (i = 0; i < this.compositeGroups.size(); ++i) {
                modelClassName = ((CompositeGroup)this.compositeGroups.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((CompositeGroup)this.compositeGroups.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</CompositeGroups_assnreflist>");
        }
        if (this.designProviders.size() > 0) {
            out.write("<DesignProviders_assnreflist>");
            for (i = 0; i < this.designProviders.size(); ++i) {
                modelClassName = ((Contact)this.designProviders.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((Contact)this.designProviders.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</DesignProviders_assnreflist>");
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNumberOfFeatures(Integer numberOfFeatures) {
        this.numberOfFeatures = numberOfFeatures;
    }

    public Integer getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    public String getModelClassName() {
        return new String("ArrayDesign");
    }

    public void setProtocolApplications(HasProtocolApplications.ProtocolApplications_list protocolApplications) {
        this.protocolApplications = protocolApplications;
    }

    public HasProtocolApplications.ProtocolApplications_list getProtocolApplications() {
        return this.protocolApplications;
    }

    public void addToProtocolApplications(ProtocolApplication protocolApplication) {
        this.protocolApplications.add(protocolApplication);
    }

    public void addToProtocolApplications(int position, ProtocolApplication protocolApplication) {
        this.protocolApplications.add(position, protocolApplication);
    }

    public ProtocolApplication getFromProtocolApplications(int position) {
        return (ProtocolApplication)this.protocolApplications.get(position);
    }

    public void removeElementAtFromProtocolApplications(int position) {
        this.protocolApplications.removeElementAt(position);
    }

    public void removeFromProtocolApplications(ProtocolApplication protocolApplication) {
        this.protocolApplications.remove(protocolApplication);
    }

    public void setFeatureGroups(HasFeatureGroups.FeatureGroups_list featureGroups) {
        this.featureGroups = featureGroups;
    }

    public HasFeatureGroups.FeatureGroups_list getFeatureGroups() {
        return this.featureGroups;
    }

    public void addToFeatureGroups(FeatureGroup featureGroup) {
        this.featureGroups.add(featureGroup);
    }

    public void addToFeatureGroups(int position, FeatureGroup featureGroup) {
        this.featureGroups.add(position, featureGroup);
    }

    public FeatureGroup getFromFeatureGroups(int position) {
        return (FeatureGroup)this.featureGroups.get(position);
    }

    public void removeElementAtFromFeatureGroups(int position) {
        this.featureGroups.removeElementAt(position);
    }

    public void removeFromFeatureGroups(FeatureGroup featureGroup) {
        this.featureGroups.remove(featureGroup);
    }

    public void setReporterGroups(HasReporterGroups.ReporterGroups_list reporterGroups) {
        this.reporterGroups = reporterGroups;
    }

    public HasReporterGroups.ReporterGroups_list getReporterGroups() {
        return this.reporterGroups;
    }

    public void addToReporterGroups(ReporterGroup reporterGroup) {
        this.reporterGroups.add(reporterGroup);
    }

    public void addToReporterGroups(int position, ReporterGroup reporterGroup) {
        this.reporterGroups.add(position, reporterGroup);
    }

    public ReporterGroup getFromReporterGroups(int position) {
        return (ReporterGroup)this.reporterGroups.get(position);
    }

    public void removeElementAtFromReporterGroups(int position) {
        this.reporterGroups.removeElementAt(position);
    }

    public void removeFromReporterGroups(ReporterGroup reporterGroup) {
        this.reporterGroups.remove(reporterGroup);
    }

    public void setCompositeGroups(HasCompositeGroups.CompositeGroups_list compositeGroups) {
        this.compositeGroups = compositeGroups;
    }

    public HasCompositeGroups.CompositeGroups_list getCompositeGroups() {
        return this.compositeGroups;
    }

    public void addToCompositeGroups(CompositeGroup compositeGroup) {
        this.compositeGroups.add(compositeGroup);
    }

    public void addToCompositeGroups(int position, CompositeGroup compositeGroup) {
        this.compositeGroups.add(position, compositeGroup);
    }

    public CompositeGroup getFromCompositeGroups(int position) {
        return (CompositeGroup)this.compositeGroups.get(position);
    }

    public void removeElementAtFromCompositeGroups(int position) {
        this.compositeGroups.removeElementAt(position);
    }

    public void removeFromCompositeGroups(CompositeGroup compositeGroup) {
        this.compositeGroups.remove(compositeGroup);
    }

    public void setDesignProviders(HasDesignProviders.DesignProviders_list designProviders) {
        this.designProviders = designProviders;
    }

    public HasDesignProviders.DesignProviders_list getDesignProviders() {
        return this.designProviders;
    }

    public void addToDesignProviders(Contact contact) {
        this.designProviders.add(contact);
    }

    public void addToDesignProviders(int position, Contact contact) {
        this.designProviders.add(position, contact);
    }

    public Contact getFromDesignProviders(int position) {
        return (Contact)this.designProviders.get(position);
    }

    public void removeElementAtFromDesignProviders(int position) {
        this.designProviders.removeElementAt(position);
    }

    public void removeFromDesignProviders(Contact contact) {
        this.designProviders.remove(contact);
    }
}

