### Name: mergeCoeff
### Title: Class mergeCoeff, a class for storing regression coefficients.
### Aliases: mergeCoeff-class mergeCoeff check.length coeff coeff<-
###   stdcoeff stdcoeff<- zscore zscore<- coeff,mergeCoeff-method
###   stdcoeff,mergeCoeff-method zscore,mergeCoeff-method
###   coeff<-,mergeCoeff-method stdcoeff<-,mergeCoeff-method
###   zscore<-,mergeCoeff-method mergeCoeff
### Keywords: classes

### ** Examples

  
  data(mergeData)
  merged  <- mergeExprs(sample1,sample2,sample3)

  log.coeff  <- modelOutcome(merged,outcome=c(1,1,1),method="logistic")
  plot(coeff(log.coeff))
  plot(stdcoeff(log.coeff),pch=4,labels=c("study A","study B","study C"),col=3)

  linear.coeff  <- modelOutcome(merged[1:2],outcome=c(3,3),method="linear")
  plot(zscore(linear.coeff))
  plot(zscore(linear.coeff),xlab="study A",ylab="study B",col=2)
  



