\name{CdfEnvAffy-class}
\docType{class}
\alias{CdfEnvAffy-class}
\alias{geneNames,CdfEnvAffy-method}
\alias{index2xy,CdfEnvAffy-method}
\alias{indexProbes,CdfEnvAffy,character-method}
\alias{plot,CdfEnvAffy,missing-method}
\alias{show,CdfEnvAffy-method}
\alias{xy2index,CdfEnvAffy-method}
\alias{coerce,CdfEnvAffy,environment-method}

\title{Class "CdfEnvAffy"}
\description{A class to hold the information necessary to handle the
  grouping of probes in set of probes, and to find XY coordinates
 of probes on a chip}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("CdfEnvAffy", ...)}.
Typically, there is an instance of the class for each type of chip
(e.g. Hu6800, HG-U95A, etc\ldots).
}
\section{Slots}{
  \describe{
    \item{\code{envir}:}{Object of class \code{"environment"}. It has to
      be tought of as a hashtable: the keys are probe set identifiers,
      or gene names, and the values are indexes.}
    \item{\code{envName}:}{Object of class \code{"character"}. A name
      for the environment.}
    \item{\code{index2xy}:}{Object of class \code{"function"}. The
      function used to resolve index into xy coordinates. Unless you are
    an advanced user, you probably want to ignore this (and rely on the
    default provided with the package).}
    \item{\code{xy2index}:}{Object of class \code{"function"}. The
      function used to resolve xy coordinates into index. Unless you are
    an advanced user, you probably want to ignore this (and rely on the
    default provided with the package).}
    \item{\code{nrow}:}{Object of class \code{"integer"}. The number of
      rows of probes for the chip type.}
    \item{\code{ncol}:}{Object of class \code{"integer"}. The number of
      columns of probes for the chip type.}
    \item{\code{probeTypes}:}{Object of class \code{"character"}. The
      different types of probes stored for each probe set. In the case
      of {\it Affymetrix} chips, the probes are typically perfect match
      (pm) probes or mismatch probes (mm).}
    \item{\code{chipType}:}{Object of class \code{"character"}. The name
      of the chip type the instance is associated with. This is useful
      when one starts to create alternative mappings of the probes on a
      chip (see associated vignette).}
  }
}
\section{Methods}{
  \describe{
    \item{coerce}{\code{signature(object = "CdfEnvAffy")}: corce an
      instance of the class to an \code{enviroment}.}
    \item{geneNames}{\code{signature(object="CdfEnvAffy")}: Return the
    names of the known probe sets (of course, it depends on the associated CDF).}
    \item{index2xy}{\code{signature(object = "CdfEnvAffy", i="integer")}: convert
      index values into XY coordinates.}
    \item{indexProbes}{\code{signature(object = "CdfEnvAffy", which =
	"character", probeSetNames = NULL)}: obtain the indexes for the probes associated wit
      the probe set name \code{probeSetNames}. When \code{probeSetNames}
      is set to \code{NULL} (default), the indexes are returned for the
      probe sets defined on the chip. See \code{indexProbes.CdfEnvAffy}}
    \item{plot}{\code{signature(x = "CdfEnvAffy", y = "missing")}: Plot
      the chip. It mainly sets coordinates for further plotting (see
      examples). See \code{plot.CdfEnvAffy}}
    \item{show}{\code{signature(object = "CdfEnvAffy")}: Print method.}
    \item{xy2index}{\code{signature(object = "CdfEnvAffy", x="integer", y="integer")}: convert XY
      coordinates into index values.}
  }
}
%\references{ ~put references to the literature/web site here ~ }
\author{Laurent Gautier}
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{indexProbes.CdfEnvAffy}}, \code{\link{plot.CdfEnvAffy}}
  %  ~~objects to See Also as \code{\link{~~fun~~}}, ~~~
%  or \code{\link{CLASSNAME-class}} for links to other classes
}
\examples{
## build an instance
library(hgu95acdf)
cdfenv.hgu95a <- wrapCdfEnvAffy(hgu95acdf, 640, 640, "HG-U95A")

show(cdfenv.hgu95a)

## find the indexes for a probe set (pm only)
ip <- indexProbes(cdfenv.hgu95a, "pm", "1000_at")[[1]]
## get the XY coordinates for the probe set
xy <- index2xy(cdfenv.hgu95a, ip)

## plot the chip
plot(cdfenv.hgu95a)

## plot the coordinates
plotLocation(xy)

}
\keyword{classes}

\eof
\name{cdfenvs}
\alias{wrapCdfEnvAffy}
\alias{getCdfEnvAffy}
\alias{buildCdfEnv.matchprobes}
\alias{CdfEnv}
\title{ functions related to cdfenvs }
\description{
  A set of functions to handle cdfenvs
}
\usage{
wrapCdfEnvAffy(cdfenv, nrow.chip, ncol.chip, chiptype)
getCdfEnvAffy(abatch)
buildCdfEnv.matchprobes(matches, ids, probes.pack, abatch=NULL,
                        nrow.chip=NULL, ncol.chip=NULL, chiptype=NULL,
                        mm=NA, simplify = TRUE,
                        x.colname = "x", y.colname = "y")
}
\arguments{
  \item{abatch}{an \code{AffyBatch}}
  \item{cdfenv}{A cdfenv environment}
  \item{chiptype}{A name for the chip type}
  \item{ids}{a vector of probe set identifiers for the matches}
  \item{matches}{a list as returned by the function
    \code{\link[matchprobes]{matchprobes}}}
  \item{mm}{The value to store for MMs}
  \item{ncol.chip}{The number of columns for the chip type}
  \item{nrow.chip}{The number of rows for the chip type}
  \item{probes.pack}{The name of the probe package}
  \item{simplify}{Simplify the environment created by removing the ids
    without any matching probe}
  \item{x.colname, y.colname}{see the \code{getxy.probeseq}}
}
\details{
  The class \code{CdfEnv} is defined as S3 to ensure compatibility with
  what is existing while changes are made.
  Migration to S4 is likely to happen after that\ldots
}
\value{
  An instance of class \code{CdfEnv}.
}
\examples{
## To appear
}
\keyword{manip}

\eof
\name{geneNames.CdfEnvAffy}
%\alias{geneNames.AltAffyBatch}
\alias{geneNames.CdfEnvAffy}
\title{ get the names of the known probe sets }
\description{
  get the names of the probe sets known to the CdfEnv
}
\usage{
%geneNames.AltAffyBatch(object)
geneNames.CdfEnvAffy(object)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{  \code{CdfEnvAffy-class}} %\code{AltAffyBatch-class} or
}
\value{
  a vector of mode \code{character}
}
\keyword{ manip}

\eof
\name{getxy.probeseq}
\alias{getxy.probeseq}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ A function to get the XY coordinates from a probes sequences
  data frame}
\description{
 A function to get the XY coordinates from a probes sequences \code{data.frame}
}
\usage{
getxy.probeseq(ppset.id = NULL, probeseq = NULL, i.row = NULL,
offset.one = TRUE, x.colname = "x", y.colname = "y")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ppset.id}{ The probe sets of interest (a vector of mode \code{character}. }
  \item{probeseq}{ The probe sequence \code{data.frame} (see details). }
  \item{i.row}{ Row indexes in the \code{data.frame} (see details). }
  \item{offset.one}{ Add one to the XY coordinates returned. }
  \item{x.colname, y.colname}{ The probe sequence packages have seen the
    names for the columns in their \code{data.frame}. This parameters
    exists to let us follow these changes.}
}
\details{
  The \code{data.frame} passed as argument \code{probeseq} is expected
  to have (at least) the following columns: \code{Probe.X},
  \code{Probe.Y} and \code{Probe.Set.Name}. When the argument
  \code{ppset.id} is not null, the probe sets
}
\value{
A \code{matrix} of two columns. The first column contains x coordinates,
while the second column contains y coordinates.
}
\author{ Laurent }

\section{Warning }{
  The parameter \code{offset.one} is currently needed, as for historical
  reasons the XY coordinates used in the affy package start at 1
  (while the XY coordinates in Affymetrix files start at zero). Play
  with this parameter at your own risks.
  
  This function should not be confused with the methods \code{index2xy}
  and similar. Here the the XY coordinate come from a \code{data.frame}
  that stores information about an arbitrary number probes on the
  chip. (See the `probe sequence' data packages on Bioconductor, and the
  package \code{matchprobes}).
  
  The methods \code{index2xy} are meant to interact with instances of
  class \code{AffyBatch}.
}

%\seealso{ ~~objects to See Also as \code{\link{~~fun~~}}, ~~~ }
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{ manip }

\eof
\name{index2xy}
\alias{index2xy}
\alias{index2xy.CdfEnvAffy}
%\alias{index2xy.AltAffyBatch}
\alias{xy2index}
\alias{xy2index.CdfEnvAffy}
%\alias{xy2index.AltAffyBatch}
\title{ Functions to shuttle from indexes to XY coordinates }
\description{
  Functions to shuttle from indexes to XY coordinates.
}
\usage{
index2xy(object, ...)
xy2index(object, ...)
index2xy.CdfEnvAffy(object, i)
%index2xy.AltAffyBatch(object, i)
xy2index.CdfEnvAffy(object, x, y)
%xy2index.AltAffyBatch(object, x, y)
}
\arguments{
  \item{object}{An object of class \code{CdfEnvAffy}.}
  \item{i}{A vector of indexes.}
  \item{x, y}{Vectors of X and Y coordinates.}
  \item{\dots}{Optional parameters (not used).}
}
\details{
  
}
\value{
  A vector of integers (for \code{xy2index} methods), or a matrix of two
  columns (for \code{index2xy} methods).
}
\section{Warning }{}

\seealso{ \code{\link{CdfEnvAffy-class}}}
\examples{
## To be done...
}
\keyword{ manip }


\eof
\name{indexProbes.CdfEnvAffy}
\alias{indexProbes.CdfEnvAffy}
%\alias{indexProbes.AltAffyBatch}
\title{ indexes for probes }
\description{
  A function to get the index for probes
}
\usage{
indexProbes.CdfEnvAffy(object, which, probeSetNames = NULL)
%indexProbes.AltAffyBatch(object, which, probeSetNames = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{ \code{CdfEnvAffy}}% or \code{AltAffyBatch}}
  \item{which}{ which kind of probe are of interest (see details). }
  \item{probeSetNames}{ names of the probe sets of interest. If
    \code{NULL}, all the probe sets are considered. }
}
\details{
  The parameter \code{which} let one specify which category of probes
  are of interest. In the case of Affymetrix chips, probes can be \code{"pm"}
  probes or \code{"mm"} probes. It the parameter is set to \code{c("pm",
    "mm")}, both are returned. Should other categories be defined, they
  can be handled as well.
  
%  One can note that the method \code{indexProbes} defined for the
%  class \code{AltAffyBatch} in only a convenience
%  accessor function (since logically the indexes are computed from the cdfenv
%  information).
}
\value{
A \code{list} of indexes.
}
\seealso{\code{\link{CdfEnvAffy-class}}, \code{\link[affyr]{AltAffyBatch-class} }}
\examples{

}
\keyword{ manip }

\eof
\name{plot.CdfEnvAffy}
\alias{plot.CdfEnvAffy}
\title{ A function to `plot' a CdfEnvAffy }
\description{
  A function to set the axis and plot the outline for a CdfEnvAffy
}
\usage{
plot.CdfEnvAffy(x, xlab = "", ylab = "", main = x@chipType, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ a \code{CdfEnvAffy} }
  \item{xlab}{ label for the rows }
  \item{ylab}{ label for the columns }
  \item{main}{ label for the plot. The chip-type by default. }
  \item{\dots}{ optional parameters to be passed to the underlying
    function \code{plot}}
}
\details{
  This function does not `plot' much, but sets the coordinates for
  further plotting (see the examples).
}
\author{ Laurent }
\seealso{\code{\link{CdfEnvAffy-class}} }
\examples{
## See "CdfEnvAffy-class"
}
\keyword{ hplot }


\eof
\name{read.FASTA.entry}
\alias{read.FASTA.entry}
\alias{print.FASTA}
\alias{write.FASTA}
\alias{skip.FASTA.entry}
\alias{read.n.FASTA.entries}
\alias{read.n.FASTA.headers}
\alias{read.n.FASTA.sequences}
\alias{read.n.FASTA.entries.split}
\alias{countskip.FASTA.entries}
\alias{read.FASTA.entry}
\alias{grep.FASTA.entry}
\title{Functions to work with FASTA files / connections}
\description{
  Set of function to work with biological sequences stored in FASTA format.
}
\usage{
countskip.FASTA.entries(linebreaks = 3000)
grep.FASTA.entry(pattern, con, ...)
print.FASTA(x, ...)
read.FASTA.entry(con, linebreaks = 3000)
read.n.FASTA.entries(con, n, linebreaks = 3000)
read.n.FASTA.entries.split(con, n, linebreaks = 3000)
read.n.FASTA.headers(con, n, linebreaks = 3000)
read.n.FASTA.sequences(con, n, linebreaks = 3000)
skip.FASTA.entry(con, skip, linebreaks = 3000)
write.FASTA(x, file="data.fasta", append = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{append}{append to the file (or not)}
  \item{con}{a \link{connection}}
  \item{file}{a file name}
  \item{linebreaks}{(to optimize the parsing, probably safe to leave it
    as it is)}
  \item{n}{number of entries to read}
  \item{pattern}{a pattern (to be passed to the function \code{grep})}
  \item{skip}{number of entries to skip}
  \item{x}{a FASTA sequence object}
  \item{...}{optional arguments to be forwarded to the function
    \code{print} or to the function \code{grep}}
}
\details{
  \code{countskip.FASTA.entries} skips the remaining FASTA entries
  currently remaining in the connection and return the count.
  \code{grep.FASTA.entry} returns the next FASTA entry in the connection
  that matches a given regular expression.
  \code{print.FASTA} prints a FASTA object.
  \code{read.FASTA.entry} reads the next FASTA entry in the connection.
  \code{read.n.FASTA.entries} reads the \code{n} next FASTA entries and
  returns a \code{list} of FASTA objects.
  \code{read.n.FASTA.entries.split} reads the \code{n} next FASTA
  entries and returns a list of two elements: headers and sequences.
  \code{read.n.FASTA.headers} reads the \code{n} next FASTA headers.
  \code{read.n.FASTA.sequences} reads the \code{n} next FASTA sequences.
  \code{skip.FASTA.entry} skips a given number of FASTA entries.
  \code{write.FASTA} write a FASTA object into a connection.
%  ~~ If necessary, more details than the __description__  above ~~
}
\value{
 The value returned depends on the function. See above.
}
\author{ Laurent Gautier }
\examples{
filename <- system.file("exampleData", "sample.fasta",
                        package="altcdfenvs")
con <- file(filename, open="r")

fasta.seq <- grep.FASTA.entry("NM_001544\\\.2", con)
close(con)


print(fasta.seq)
}
\keyword{ manip }
\keyword{ IO }
\keyword{ connection }

\eof
\name{validAffyBatch}
\alias{validAffyBatch}
\alias{validCdfEnvAffy}
\alias{printValidCdfEnvAffy}
\title{Check validity of a CdfEnvAffy.}
\description{
  Tries to see if a CdfEnvAffy, or a pair of AffyBatch / CdfEnvAffy is valid.
}
\usage{
validAffyBatch(abatch, cdfenv)
validCdfEnvAffy(cdfenv, verbose=TRUE)
printValidCdfEnvAffy(x)
}
\arguments{
  \item{abatch}{ instance of \code{\link[affy]{AffyBatch-class}} }
  \item{cdfenv}{ instance of \code{\link{CdfEnvAffy-class}} }
  \item{verbose}{ verbose or not}
  \item{x}{object returned by \code{validCdfEnvAffy}}
}
\details{
  The function \code{validAffyBatch} calls in turn
  \code{validCdfEnvAffy}.
}
\value{

}
\seealso{ \code{\link[affy]{AffyBatch-class}}, \code{\link{CdfEnvAffy-class}} }
\examples{
## To be done...
}
\keyword{ manip }


\eof
