/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.tools.xmlutils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.text.ParseException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.biomage.AuditAndSecurity.Audit;
import org.biomage.Common.MAGEJava;
import org.biomage.tools.helpers.StringOutputHelpers;
import org.biomage.tools.xmlutils.MAGEContentHandler;
import org.biomage.tools.xmlutils.MAGEReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class MAGEReader {
    protected MAGEJava mageObj;

    public MAGEReader(String filename) {
        StringOutputHelpers.setVerbose(0);
        try {
            SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
            SAXParser parser = factory.newSAXParser();
            MAGEContentHandler cHandler = new MAGEContentHandler();
            File fileHandle = new File(filename);
            if (fileHandle.exists()) {
                if (fileHandle.isFile()) {
                    parser.parse(fileHandle, (DefaultHandler)cHandler);
                } else if (fileHandle.isDirectory()) {
                    cHandler.setLastDocument(false);
                    File[] magemlFiles = fileHandle.listFiles(new FilenameFilter(){

                        public boolean accept(File file, String name) {
                            return name.matches(".+.xml");
                        }
                    });
                    int i = 0;
                    while (i < magemlFiles.length - 1) {
                        parser.parse(magemlFiles[i].getAbsolutePath(), (DefaultHandler)cHandler);
                        ++i;
                    }
                    cHandler.setLastDocument(true);
                    parser.parse(magemlFiles[magemlFiles.length - 1].getAbsolutePath(), (DefaultHandler)cHandler);
                }
                this.mageObj = cHandler.getMAGEJava();
            } else {
                this.mageObj = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(args[0]);
        MAGEReader mAGEReader = new MAGEReader(args[0]);
    }

    public MAGEJava getMAGEobj() {
        return this.mageObj;
    }

    private void testing1() throws Exception {
        FileWriter tmpFile = new FileWriter("./raw.xml");
        this.mageObj.writeMAGEML(tmpFile);
        tmpFile.flush();
        tmpFile.close();
        OutputFormat xmlFormat = new OutputFormat("xml", "utf-8", true);
        xmlFormat.setLineWidth(60);
        xmlFormat.setLineSeparator("\n");
        XMLSerializer xmlWriterDocHndler = new XMLSerializer((OutputStream)System.out, xmlFormat);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser xmlWriterParser = factory.newSAXParser();
        xmlWriterParser.getXMLReader().setContentHandler((ContentHandler)xmlWriterDocHndler);
        xmlWriterParser.getXMLReader().parse(new InputSource(new FileReader("./raw.xml")));
    }

    private void testing2() throws Exception {
        class Audit2
        extends Audit {
            private final /* synthetic */ MAGEReader this$0;

            Audit2(MAGEReader this$0) {
                this.this$0 = this$0;
            }
        }
        Audit2 audit = new Audit2(this);
        FileWriter tmpFile = new FileWriter("./raw.xml");
        audit.writeMAGEML(tmpFile);
        tmpFile.flush();
        tmpFile.close();
        OutputFormat xmlFormat = new OutputFormat("xml", "utf-8", true);
        xmlFormat.setLineWidth(60);
        xmlFormat.setLineSeparator("\n");
        XMLSerializer xmlWriterDocHndler = new XMLSerializer((OutputStream)System.out, xmlFormat);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser xmlWriterParser = factory.newSAXParser();
        xmlWriterParser.getXMLReader().setContentHandler((ContentHandler)xmlWriterDocHndler);
        xmlWriterParser.getXMLReader().parse(new InputSource(new FileReader("./raw.xml")));
    }
}

