/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.tools.helpers;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class StringOutputHelpers {
    public static final String NEWLINE = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    public static String oneIndent = "    ";
    protected static String javaBodyIndent;
    protected static String cppBodyIndent;
    protected static int verbose;

    public static void setVerbose(int level) {
        verbose = level;
    }

    public static void writeOutput(String mess, int level) {
        if (level <= verbose) {
            System.out.println(mess);
        }
    }

    public static String initialCap(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String initialLower(String string) throws Exception {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static void writeJavaComment(FileWriter writer, String comment, int indentLevel, String keyWord, boolean startComment, boolean endComment) throws Exception {
        String delimIndent = javaBodyIndent;
        String indent = "";
        int keyWordRoom = null == keyWord ? 0 : keyWord.length();
        for (int i = 0; i < indentLevel; ++i) {
            indent = oneIndent + indent;
            if (1 == i) continue;
            delimIndent = oneIndent + delimIndent;
        }
        if (startComment) {
            writer.write(indent + "/**" + NEWLINE);
        }
        if (null == comment || 0 == comment.trim().length()) {
            writer.write(delimIndent + NEWLINE);
        } else {
            Vector commentLines = StringOutputHelpers.wrapString(comment.trim(), 72 - indent.length(), keyWordRoom + 3);
            StringOutputHelpers.writeCommentBody(writer, commentLines, keyWord, delimIndent);
        }
        if (endComment) {
            writer.write(delimIndent + NEWLINE);
            writer.write(indent + " */" + NEWLINE);
        }
    }

    protected static void writeCPPComment(FileWriter writer, String comment, int indentLevel, String keyWord, boolean startComment, boolean endComment) throws Exception {
        Vector commentLines;
        if (null == comment || 0 == comment.trim().length()) {
            return;
        }
        String delimIndent = cppBodyIndent;
        String indent = "";
        int keyWordRoom = null == keyWord ? 0 : keyWord.length();
        for (int i = 0; i < indentLevel; ++i) {
            indent = oneIndent + indent;
        }
        if (startComment) {
            writer.write(indent + "/**" + "" + NEWLINE + "");
        }
        if (0 < (commentLines = StringOutputHelpers.wrapString(comment.trim(), 72 - indent.length(), keyWordRoom + 3)).size()) {
            if (null != keyWord) {
                String firstLine = keyWord + " " + (String)commentLines.elementAt(0);
                commentLines.setElementAt(firstLine, 0);
            }
            for (int i = 0; i < commentLines.size(); ++i) {
                writer.write(indent + " * " + (String)commentLines.elementAt(i) + NEWLINE);
            }
        }
        if (endComment) {
            writer.write(indent + " */" + NEWLINE);
        }
    }

    public static void writeDTDComment(FileWriter writer, String comment, String keyWord, boolean startComment, boolean endComment) throws Exception {
        int keyWordRoom;
        if (null == comment || 0 == (comment = comment.trim()).length()) {
            return;
        }
        int n = keyWordRoom = null == keyWord ? 0 : keyWord.length();
        if (startComment) {
            writer.write("<!--" + NEWLINE);
        }
        Vector commentLines = StringOutputHelpers.wrapString(comment.trim(), 72 - oneIndent.length(), keyWordRoom + 3);
        StringOutputHelpers.writeCommentBody(writer, commentLines, keyWord, oneIndent);
        if (endComment) {
            writer.write("-->" + NEWLINE);
        }
    }

    protected static void writeCommentBody(FileWriter writer, Vector commentLines, String keyWord, String delimIndent) throws Exception {
        if (0 < commentLines.size()) {
            if (null != keyWord) {
                String firstLine = keyWord + " " + (String)commentLines.elementAt(0);
                commentLines.setElementAt(firstLine, 0);
            }
            for (int i = 0; i < commentLines.size(); ++i) {
                String line = (String)commentLines.elementAt(i);
                writer.write(delimIndent + line + NEWLINE);
            }
        }
    }

    protected static Vector wrapString(String string, int lineLength, int firstLineOffset) throws Exception {
        Vector<String> strings = new Vector<String>();
        int index = -1;
        int nextChunk = lineLength - firstLineOffset;
        while (string.length() > nextChunk) {
            int nextStart = 0;
            index = string.indexOf(NEWLINE);
            if (-1 == index || index > nextChunk) {
                int tabIndex = string.lastIndexOf(9, nextChunk);
                int spaceIndex = string.lastIndexOf(32, nextChunk);
                index = -1 == tabIndex && -1 == spaceIndex ? lineLength : (spaceIndex > tabIndex ? spaceIndex : tabIndex) + 1;
            } else {
                nextStart = NEWLINE.length();
            }
            String nextLine = string.substring(0, index);
            strings.addElement(nextLine);
            string = string.substring(index + nextStart);
            nextChunk = lineLength;
        }
        if (0 < string.length()) {
            while (-1 != (index = string.indexOf(NEWLINE))) {
                String nextLine = string.substring(0, index);
                strings.addElement(nextLine);
                string = string.substring(index + NEWLINE.length());
                nextChunk = lineLength;
            }
            if (0 < string.length()) {
                strings.addElement(string);
            }
        }
        return strings;
    }

    public static void writeHeader(FileWriter writer, File header) throws Exception {
        FileReader reader = new FileReader(header);
        int curChar = -1;
        while (-1 != (curChar = reader.read())) {
            if (37 == curChar) {
                while (37 != reader.read()) {
                }
                SimpleDateFormat format = new SimpleDateFormat("EEE, MMM dd, yyyy hh:mm:ss a");
                String date = format.format(new Date());
                writer.write(date, 0, date.length());
                continue;
            }
            writer.write(curChar);
        }
        reader.close();
    }

    public static String createPackageDir(String fullOutputDir, String packageDirName) throws Exception {
        File packageDir;
        if (fullOutputDir.length() - 1 != fullOutputDir.lastIndexOf(File.separatorChar)) {
            fullOutputDir = fullOutputDir + File.separatorChar;
        }
        if (!(packageDir = new File(fullOutputDir = fullOutputDir + packageDirName)).exists() && !packageDir.mkdirs()) {
            throw new Exception("printJavaClassFile(): Could not create the packageDir path " + fullOutputDir);
        }
        return fullOutputDir;
    }

    static {
        cppBodyIndent = javaBodyIndent = " *  ";
        verbose = 0;
    }
}

