/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.Common.Identifiable;
import org.biomage.Interface.HasParameterTypes;
import org.biomage.Protocol.Parameter;
import org.xml.sax.Attributes;

public abstract class Parameterizable
extends Identifiable
implements Serializable,
HasParameterTypes {
    String URI;
    protected HasParameterTypes.ParameterTypes_list parameterTypes = new HasParameterTypes.ParameterTypes_list();

    public Parameterizable() {
    }

    public Parameterizable(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "URI");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.URI = atts.getValue(nIndex);
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.URI != null) {
            out.write(" URI=\"" + this.URI + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.parameterTypes.size() > 0) {
            out.write("<ParameterTypes_assnlist>");
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                ((Parameter)this.parameterTypes.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ParameterTypes_assnlist>");
        }
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public String getURI() {
        return this.URI;
    }

    public String getModelClassName() {
        return new String("Parameterizable");
    }

    public void setParameterTypes(HasParameterTypes.ParameterTypes_list parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public HasParameterTypes.ParameterTypes_list getParameterTypes() {
        return this.parameterTypes;
    }

    public void addToParameterTypes(Parameter parameter) {
        this.parameterTypes.add(parameter);
    }

    public void addToParameterTypes(int position, Parameter parameter) {
        this.parameterTypes.add(position, parameter);
    }

    public Parameter getFromParameterTypes(int position) {
        return (Parameter)this.parameterTypes.get(position);
    }

    public void removeElementAtFromParameterTypes(int position) {
        this.parameterTypes.removeElementAt(position);
    }

    public void removeFromParameterTypes(Parameter parameter) {
        this.parameterTypes.remove(parameter);
    }
}

