/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.Experiment;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioAssay.BioAssay;
import org.biomage.Common.Describable;
import org.biomage.Description.Description;
import org.biomage.Description.OntologyEntry;
import org.biomage.Experiment.ExperimentalFactor;
import org.biomage.Interface.HasExperimentalFactors;
import org.biomage.Interface.HasNormalizationDescription;
import org.biomage.Interface.HasQualityControlDescription;
import org.biomage.Interface.HasReplicateDescription;
import org.biomage.Interface.HasTopLevelBioAssays;
import org.biomage.Interface.HasTypes;
import org.xml.sax.Attributes;

public class ExperimentDesign
extends Describable
implements Serializable,
HasTopLevelBioAssays,
HasExperimentalFactors,
HasReplicateDescription,
HasQualityControlDescription,
HasNormalizationDescription,
HasTypes {
    protected HasTypes.Types_list types = new HasTypes.Types_list();
    protected HasTopLevelBioAssays.TopLevelBioAssays_list topLevelBioAssays = new HasTopLevelBioAssays.TopLevelBioAssays_list();
    protected HasExperimentalFactors.ExperimentalFactors_list experimentalFactors = new HasExperimentalFactors.ExperimentalFactors_list();
    protected Description qualityControlDescription;
    protected Description normalizationDescription;
    protected Description replicateDescription;

    public ExperimentDesign() {
    }

    public ExperimentDesign(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<ExperimentDesign");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</ExperimentDesign>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.types.size() > 0) {
            out.write("<Types_assnlist>");
            for (i = 0; i < this.types.size(); ++i) {
                ((OntologyEntry)this.types.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Types_assnlist>");
        }
        if (this.topLevelBioAssays.size() > 0) {
            out.write("<TopLevelBioAssays_assnreflist>");
            for (i = 0; i < this.topLevelBioAssays.size(); ++i) {
                String modelClassName = ((BioAssay)this.topLevelBioAssays.elementAt(i)).getModelClassName();
                out.write("<" + modelClassName + "_ref identifier=\"" + ((BioAssay)this.topLevelBioAssays.elementAt(i)).getIdentifier() + "\"/>");
            }
            out.write("</TopLevelBioAssays_assnreflist>");
        }
        if (this.experimentalFactors.size() > 0) {
            out.write("<ExperimentalFactors_assnlist>");
            for (i = 0; i < this.experimentalFactors.size(); ++i) {
                ((ExperimentalFactor)this.experimentalFactors.elementAt(i)).writeMAGEML(out);
            }
            out.write("</ExperimentalFactors_assnlist>");
        }
        if (this.qualityControlDescription != null) {
            out.write("<QualityControlDescription_assn>");
            this.qualityControlDescription.writeMAGEML(out);
            out.write("</QualityControlDescription_assn>");
        }
        if (this.normalizationDescription != null) {
            out.write("<NormalizationDescription_assn>");
            this.normalizationDescription.writeMAGEML(out);
            out.write("</NormalizationDescription_assn>");
        }
        if (this.replicateDescription != null) {
            out.write("<ReplicateDescription_assn>");
            this.replicateDescription.writeMAGEML(out);
            out.write("</ReplicateDescription_assn>");
        }
    }

    public String getModelClassName() {
        return new String("ExperimentDesign");
    }

    public void setTypes(HasTypes.Types_list types) {
        this.types = types;
    }

    public HasTypes.Types_list getTypes() {
        return this.types;
    }

    public void addToTypes(OntologyEntry ontologyEntry) {
        this.types.add(ontologyEntry);
    }

    public void addToTypes(int position, OntologyEntry ontologyEntry) {
        this.types.add(position, ontologyEntry);
    }

    public OntologyEntry getFromTypes(int position) {
        return (OntologyEntry)this.types.get(position);
    }

    public void removeElementAtFromTypes(int position) {
        this.types.removeElementAt(position);
    }

    public void removeFromTypes(OntologyEntry ontologyEntry) {
        this.types.remove(ontologyEntry);
    }

    public void setTopLevelBioAssays(HasTopLevelBioAssays.TopLevelBioAssays_list topLevelBioAssays) {
        this.topLevelBioAssays = topLevelBioAssays;
    }

    public HasTopLevelBioAssays.TopLevelBioAssays_list getTopLevelBioAssays() {
        return this.topLevelBioAssays;
    }

    public void addToTopLevelBioAssays(BioAssay bioAssay) {
        this.topLevelBioAssays.add(bioAssay);
    }

    public void addToTopLevelBioAssays(int position, BioAssay bioAssay) {
        this.topLevelBioAssays.add(position, bioAssay);
    }

    public BioAssay getFromTopLevelBioAssays(int position) {
        return (BioAssay)this.topLevelBioAssays.get(position);
    }

    public void removeElementAtFromTopLevelBioAssays(int position) {
        this.topLevelBioAssays.removeElementAt(position);
    }

    public void removeFromTopLevelBioAssays(BioAssay bioAssay) {
        this.topLevelBioAssays.remove(bioAssay);
    }

    public void setExperimentalFactors(HasExperimentalFactors.ExperimentalFactors_list experimentalFactors) {
        this.experimentalFactors = experimentalFactors;
    }

    public HasExperimentalFactors.ExperimentalFactors_list getExperimentalFactors() {
        return this.experimentalFactors;
    }

    public void addToExperimentalFactors(ExperimentalFactor experimentalFactor) {
        this.experimentalFactors.add(experimentalFactor);
    }

    public void addToExperimentalFactors(int position, ExperimentalFactor experimentalFactor) {
        this.experimentalFactors.add(position, experimentalFactor);
    }

    public ExperimentalFactor getFromExperimentalFactors(int position) {
        return (ExperimentalFactor)this.experimentalFactors.get(position);
    }

    public void removeElementAtFromExperimentalFactors(int position) {
        this.experimentalFactors.removeElementAt(position);
    }

    public void removeFromExperimentalFactors(ExperimentalFactor experimentalFactor) {
        this.experimentalFactors.remove(experimentalFactor);
    }

    public void setQualityControlDescription(Description qualityControlDescription) {
        this.qualityControlDescription = qualityControlDescription;
    }

    public Description getQualityControlDescription() {
        return this.qualityControlDescription;
    }

    public void setNormalizationDescription(Description normalizationDescription) {
        this.normalizationDescription = normalizationDescription;
    }

    public Description getNormalizationDescription() {
        return this.normalizationDescription;
    }

    public void setReplicateDescription(Description replicateDescription) {
        this.replicateDescription = replicateDescription;
    }

    public Description getReplicateDescription() {
        return this.replicateDescription;
    }
}

