/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.BioMaterial;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.biomage.BioMaterial.Treatment;
import org.biomage.Common.Identifiable;
import org.biomage.Common.NameValueType;
import org.biomage.Description.OntologyEntry;
import org.biomage.Interface.HasCharacteristics;
import org.biomage.Interface.HasMaterialType;
import org.biomage.Interface.HasQualityControlStatistics;
import org.biomage.Interface.HasTreatments;
import org.xml.sax.Attributes;

public abstract class BioMaterial
extends Identifiable
implements Serializable,
HasTreatments,
HasMaterialType,
HasCharacteristics,
HasQualityControlStatistics {
    protected HasQualityControlStatistics.QualityControlStatistics_list qualityControlStatistics = new HasQualityControlStatistics.QualityControlStatistics_list();
    protected HasCharacteristics.Characteristics_list characteristics = new HasCharacteristics.Characteristics_list();
    protected OntologyEntry materialType;
    protected HasTreatments.Treatments_list treatments = new HasTreatments.Treatments_list();

    public BioMaterial() {
    }

    public BioMaterial(Attributes atts) {
        super(atts);
    }

    public void writeMAGEML(Writer out) throws IOException {
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
    }

    public void writeAssociations(Writer out) throws IOException {
        int i;
        super.writeAssociations(out);
        if (this.qualityControlStatistics.size() > 0) {
            out.write("<QualityControlStatistics_assnlist>");
            for (i = 0; i < this.qualityControlStatistics.size(); ++i) {
                ((NameValueType)this.qualityControlStatistics.elementAt(i)).writeMAGEML(out);
            }
            out.write("</QualityControlStatistics_assnlist>");
        }
        if (this.characteristics.size() > 0) {
            out.write("<Characteristics_assnlist>");
            for (i = 0; i < this.characteristics.size(); ++i) {
                ((OntologyEntry)this.characteristics.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Characteristics_assnlist>");
        }
        if (this.materialType != null) {
            out.write("<MaterialType_assn>");
            this.materialType.writeMAGEML(out);
            out.write("</MaterialType_assn>");
        }
        if (this.treatments.size() > 0) {
            out.write("<Treatments_assnlist>");
            for (i = 0; i < this.treatments.size(); ++i) {
                ((Treatment)this.treatments.elementAt(i)).writeMAGEML(out);
            }
            out.write("</Treatments_assnlist>");
        }
    }

    public String getModelClassName() {
        return new String("BioMaterial");
    }

    public void setQualityControlStatistics(HasQualityControlStatistics.QualityControlStatistics_list qualityControlStatistics) {
        this.qualityControlStatistics = qualityControlStatistics;
    }

    public HasQualityControlStatistics.QualityControlStatistics_list getQualityControlStatistics() {
        return this.qualityControlStatistics;
    }

    public void addToQualityControlStatistics(NameValueType nameValueType) {
        this.qualityControlStatistics.add(nameValueType);
    }

    public void addToQualityControlStatistics(int position, NameValueType nameValueType) {
        this.qualityControlStatistics.add(position, nameValueType);
    }

    public NameValueType getFromQualityControlStatistics(int position) {
        return (NameValueType)this.qualityControlStatistics.get(position);
    }

    public void removeElementAtFromQualityControlStatistics(int position) {
        this.qualityControlStatistics.removeElementAt(position);
    }

    public void removeFromQualityControlStatistics(NameValueType nameValueType) {
        this.qualityControlStatistics.remove(nameValueType);
    }

    public void setCharacteristics(HasCharacteristics.Characteristics_list characteristics) {
        this.characteristics = characteristics;
    }

    public HasCharacteristics.Characteristics_list getCharacteristics() {
        return this.characteristics;
    }

    public void addToCharacteristics(OntologyEntry ontologyEntry) {
        this.characteristics.add(ontologyEntry);
    }

    public void addToCharacteristics(int position, OntologyEntry ontologyEntry) {
        this.characteristics.add(position, ontologyEntry);
    }

    public OntologyEntry getFromCharacteristics(int position) {
        return (OntologyEntry)this.characteristics.get(position);
    }

    public void removeElementAtFromCharacteristics(int position) {
        this.characteristics.removeElementAt(position);
    }

    public void removeFromCharacteristics(OntologyEntry ontologyEntry) {
        this.characteristics.remove(ontologyEntry);
    }

    public void setMaterialType(OntologyEntry materialType) {
        this.materialType = materialType;
    }

    public OntologyEntry getMaterialType() {
        return this.materialType;
    }

    public void setTreatments(HasTreatments.Treatments_list treatments) {
        this.treatments = treatments;
    }

    public HasTreatments.Treatments_list getTreatments() {
        return this.treatments;
    }

    public void addToTreatments(Treatment treatment) {
        this.treatments.add(treatment);
    }

    public void addToTreatments(int position, Treatment treatment) {
        this.treatments.add(position, treatment);
    }

    public Treatment getFromTreatments(int position) {
        return (Treatment)this.treatments.get(position);
    }

    public void removeElementAtFromTreatments(int position) {
        this.treatments.removeElementAt(position);
    }

    public void removeFromTreatments(Treatment treatment) {
        this.treatments.remove(treatment);
    }
}

