/*
 * Decompiled with CFR 0.152.
 */
package org.biomage.AuditAndSecurity;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.biomage.AuditAndSecurity.Contact;
import org.biomage.Common.Describable;
import org.biomage.Interface.HasPerformer;
import org.xml.sax.Attributes;

public class Audit
extends Describable
implements Serializable,
HasPerformer {
    Date date;
    Action action = new Action();
    protected Contact performer;

    public Audit() {
    }

    public Audit(Attributes atts) {
        super(atts);
        int nIndex = atts.getIndex("", "date");
        if (nIndex != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            try {
                this.date = new SimpleDateFormat("yyyy-MM-dd").parse(atts.getValue(nIndex));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((nIndex = atts.getIndex("", "action")) != -1 && null != atts.getValue(nIndex) && 0 < atts.getValue(nIndex).length()) {
            this.action.setValueByName(atts.getValue(nIndex));
        }
    }

    public void writeMAGEML(Writer out) throws IOException {
        if (!this.emptyMAGEobject()) {
            out.write("<Audit");
            this.writeAttributes(out);
            out.write(">");
            this.writeAssociations(out);
            out.write("</Audit>");
        }
    }

    public boolean emptyMAGEobject() {
        return this.getPropertySets().size() == 1 && this.getFromPropertySets(0).getName().equals("Placeholder");
    }

    public void writeAttributes(Writer out) throws IOException {
        super.writeAttributes(out);
        if (this.date != null) {
            out.write(" date=\"" + this.date + "\"");
        }
        if (this.action != null) {
            out.write(" action=\"" + this.action + "\"");
        }
    }

    public void writeAssociations(Writer out) throws IOException {
        super.writeAssociations(out);
        if (this.performer != null) {
            out.write("<Performer_assnref>");
            out.write("<" + this.performer.getModelClassName() + "_ref identifier=\"" + this.performer.getIdentifier() + "\"/>");
            out.write("</Performer_assnref>");
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public String setNameByValueAction(int val) {
        return this.getAction().setNameByValue(val);
    }

    public int setValueByNameAction(String name) {
        return this.getAction().setValueByName(name);
    }

    public String getNameByValueAction(int val) {
        return this.getAction().getNameByValue(val);
    }

    public int getValueByNameAction(String name) {
        return this.getAction().getValueByName(name);
    }

    public String getNameAction() {
        return this.getAction().getName();
    }

    public int getValueAction() {
        return this.getAction().getValue();
    }

    public String getModelClassName() {
        return new String("Audit");
    }

    public void setPerformer(Contact performer) {
        this.performer = performer;
    }

    public Contact getPerformer() {
        return this.performer;
    }

    public class Action {
        int value = -1;
        String name = null;
        private HashMap nameToValue = new HashMap(2);
        private HashMap valueToName = new HashMap(2);
        public final int creation = 0;
        public final int modification = 1;

        Action() {
            this.nameToValue.put("creation", new Integer(0));
            this.valueToName.put(new Integer(0), "creation");
            this.nameToValue.put("modification", new Integer(1));
            this.valueToName.put(new Integer(1), "modification");
        }

        public int setValueByName(String name) {
            this.value = (Integer)this.nameToValue.get(name);
            return this.value;
        }

        public int getValueByName(String name) {
            return (Integer)this.nameToValue.get(name);
        }

        public String setNameByValue(int val) {
            this.name = (String)this.valueToName.get(new Integer(val));
            return this.name;
        }

        public String getNameByValue(int val) {
            return (String)this.valueToName.get(new Integer(val));
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getNameByValue(this.getValue());
        }
    }
}

