/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class ExsltDatetime {
    static final String dt = "yyyy-MM-dd'T'HH:mm:ss";
    static final String d = "yyyy-MM-dd";
    static final String gym = "yyyy-MM";
    static final String gy = "yyyy";
    static final String gmd = "MM-dd";
    static final String gm = "MM";
    static final String gd = "dd";
    static final String t = "HH:mm:ss";

    private static String formatDigits(int q) {
        String dd = String.valueOf(Math.abs(q));
        return dd.length() == 1 ? '0' + dd : dd;
    }

    private static int getZoneStart(String datetime) {
        if (datetime.indexOf("Z") == datetime.length() - 1) {
            return datetime.indexOf("Z");
        }
        if (datetime.lastIndexOf("-") == datetime.length() - 6 && datetime.charAt(datetime.length() - 3) == ':' || datetime.indexOf("+") == datetime.length() - 6) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
                dateFormat.setLenient(false);
                Date d = dateFormat.parse(datetime.substring(datetime.length() - 5));
                return datetime.length() - 6;
            }
            catch (ParseException pe) {
                System.out.println("ParseException " + pe.getErrorOffset());
                return -2;
            }
        }
        return -1;
    }

    public static XBoolean leapYear() {
        Calendar cal = Calendar.getInstance();
        int yr = cal.get(1);
        return new XBoolean(yr % 400 == 0 || yr % 100 != 0 && yr % 4 == 0);
    }

    public static XNumber dayInMonth() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(5));
    }

    public static XNumber dayInWeek() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(7));
    }

    public static XNumber dayInYear() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(6));
    }

    public static XNumber dayOfWeekInMonth() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(8));
    }

    public static XNumber hourInDay() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(11));
    }

    public static XNumber minuteInHour() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(12));
    }

    public static XNumber monthInYear() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(2));
    }

    public static XNumber secondInMinute() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(13));
    }

    public static XNumber weekInYear() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(3));
    }

    public static XNumber year() {
        Calendar cal = Calendar.getInstance();
        return new XNumber(cal.get(1));
    }

    public static XString date() {
        String datetime = ExsltDatetime.dateTime().toString();
        String date = datetime.substring(0, datetime.indexOf("T"));
        String zone = datetime.substring(ExsltDatetime.getZoneStart(datetime));
        return new XString(date + zone);
    }

    public static XString dateTime() {
        Calendar cal = Calendar.getInstance();
        Date datetime = cal.getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat(dt);
        StringBuffer buff = new StringBuffer(dateFormat.format(datetime));
        int offset = cal.get(15) + cal.get(16);
        if (offset == 0) {
            buff.append("Z");
        } else {
            int hrs = offset / 3600000;
            int min = offset % 3600000;
            char posneg = hrs < 0 ? (char)'-' : '+';
            buff.append(posneg + ExsltDatetime.formatDigits(hrs) + ':' + ExsltDatetime.formatDigits(min));
        }
        return new XString(buff.toString());
    }

    public static XString dayAbbreviation() {
        String format = "EEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(format));
    }

    public static XString dayName() {
        String format = "EEEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(format));
    }

    public static XString monthAbbreviation() {
        String format = "MMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(format));
    }

    public static XString monthName() {
        Calendar cal = Calendar.getInstance();
        String format = "MMMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(format));
    }

    public static XString time() {
        String datetime = ExsltDatetime.dateTime().toString();
        String time = datetime.substring(datetime.indexOf("T") + 1);
        String zone = datetime.substring(ExsltDatetime.getZoneStart(datetime));
        return new XString(time + zone);
    }

    private static String getNameOrAbbrev(String format) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(cal.getTime());
    }

    private static String[] getEraDatetimeZone(String in) {
        int z;
        String leader = "";
        String datetime = in;
        String zone = "";
        if (in.charAt(0) == '-') {
            leader = "-";
            datetime = in.substring(1);
        }
        if ((z = ExsltDatetime.getZoneStart(datetime)) > 0) {
            zone = datetime.substring(z);
            datetime = datetime.substring(0, z);
        } else if (z == -2) {
            zone = null;
        }
        return new String[]{leader, datetime, zone};
    }

    private static double getNumber(String in, String[] formats, int calField) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        Date date = ExsltDatetime.testFormats(in, formats);
        if (date == null) {
            return Double.NaN;
        }
        cal.setTime(date);
        return cal.get(calField);
    }

    public static XNumber dayInMonth(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        String[] formats = new String[]{dt, d, gmd, gd};
        double day = ExsltDatetime.getNumber(datetime, formats, 5);
        return new XNumber(day);
    }

    public static XNumber dayInWeek(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 7));
    }

    public static XNumber dayInYear(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 6));
    }

    public static XNumber dayOfWeekInMonth(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 8));
    }

    public static XNumber hourInDay(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{d, t};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 11));
    }

    public static XNumber minuteInHour(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, t};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 12));
    }

    public static XNumber monthInYear(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d, gym};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 2));
    }

    public static XNumber secondInMinute(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, t};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 13));
    }

    public static XNumber weekInYear(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(datetime, formats, 3));
    }

    public static XNumber year(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        boolean ad = edz[0].length() == 0;
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d, gym, gy};
        double yr = ExsltDatetime.getNumber(datetime, formats, 1);
        if (ad || yr == Double.NaN) {
            return new XNumber(yr);
        }
        return new XNumber(-yr);
    }

    public static XObject leapYear(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XNumber(Double.NaN);
        }
        String[] formats = new String[]{dt, d, gym, gy};
        double dbl = ExsltDatetime.getNumber(datetime, formats, 1);
        if (dbl == Double.NaN) {
            return new XNumber(Double.NaN);
        }
        int yr = (int)dbl;
        return new XBoolean(yr % 400 == 0 || yr % 100 != 0 && yr % 4 == 0);
    }

    public static XString date(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String leader = edz[0];
        String datetime = edz[1];
        String zone = edz[2];
        if (datetime == null || zone == null) {
            return new XString("");
        }
        String[] formatsIn = new String[]{dt, d};
        String formatOut = d;
        Date date = ExsltDatetime.testFormats(datetime, formatsIn);
        if (date == null) {
            return new XString("");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatOut);
        dateFormat.setLenient(false);
        String dateOut = dateFormat.format(date);
        if (dateOut.length() == 0) {
            return new XString("");
        }
        return new XString(leader + dateOut + zone);
    }

    public static XString dayAbbreviation(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XString("");
        }
        String[] formatsIn = new String[]{dt, d};
        String formatOut = "EEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, formatOut));
    }

    public static XString dayName(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XString("");
        }
        String[] formatsIn = new String[]{dt, d};
        String formatOut = "EEEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, formatOut));
    }

    public static XString monthAbbreviation(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XString("");
        }
        String[] formatsIn = new String[]{dt, d, gym, gm};
        String formatOut = "MMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, formatOut));
    }

    public static XString monthName(String datetimeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(datetimeIn);
        String datetime = edz[1];
        if (datetime == null) {
            return new XString("");
        }
        String[] formatsIn = new String[]{dt, d, gym, gm};
        String formatOut = "MMMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(datetimeIn, formatsIn, formatOut));
    }

    public static XString time(String timeIn) throws ParseException {
        String[] edz = ExsltDatetime.getEraDatetimeZone(timeIn);
        String time = edz[1];
        String zone = edz[2];
        if (time == null || zone == null) {
            return new XString("");
        }
        String[] formatsIn = new String[]{dt, d};
        String formatOut = t;
        Date date = ExsltDatetime.testFormats(time, formatsIn);
        if (date == null) {
            return new XString("");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatOut);
        String out = dateFormat.format(date);
        return new XString(out + zone);
    }

    private static Date testFormats(String in, String[] formats) throws ParseException {
        int i = 0;
        while (i < formats.length) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(formats[i]);
                dateFormat.setLenient(false);
                return dateFormat.parse(in);
            }
            catch (ParseException pe) {
                if (pe.getErrorOffset() < in.length()) {
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    private static String getNameOrAbbrev(String in, String[] formatsIn, String formatOut) throws ParseException {
        int i = 0;
        while (i < formatsIn.length) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(formatsIn[i]);
                dateFormat.setLenient(false);
                Date dt = dateFormat.parse(in);
                dateFormat.applyPattern(formatOut);
                return dateFormat.format(dt);
            }
            catch (ParseException pe) {
                if (pe.getErrorOffset() < in.length()) {
                    return "";
                }
                ++i;
            }
        }
        return "";
    }
}

