### Name: eSetFilter
### Title: A function to filter an eSet object
### Aliases: eSetFilter getFilterNames getFuncDesc getRdAsText parseDesc
###   parseArgs eSet setESetArgs isESet showESet
### Keywords: manip

### ** Examples

  if(interactive()){
      library(genefilter)
      library(Biobase)
      data(geneData)
      data(geneCov)
      covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
      names(covdesc) <- names(geneCov)
      pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
      eset <- new("exprSet", exprs=geneData, phenoData=pdata)

      res <- eSetFilter(eset)
  }



