\name{uuidt-class}
\docType{class}
\alias{uuidt-class}
\alias{uuidt}
\title{Class "uuidt": A class to contain UUID values}
\description{Class \code{uuidt} wraps the actual byte values for a UUID}
\section{Objects from the Class}{
  Objects of class \code{uuidt} are not intended to be created directly
  by the user.  A call to \code{getuuid} or \code{str2uuid} will
  generate such a value.
}
\section{Slots}{
  \describe{
    \item{\code{uuid}:}{Object of class \code{"character"}: Byte values
      of the UUID}
  }
}

\section{Methods}{
  \describe{
    \item{uuid}{Retrieves the byte string of the UUID}
    \item{print}{Prints a human readable display of the byte values}
  }
}
\references{Theodore Ts'o's Universally Unique ID library\cr
  \url{http://web.mit.edu/tytso/www/home.html}}
\author{R. Gentleman and Jeff Gentry}
\seealso{\code{\link{getuuid}}, \code{\link{Ruuid}}}

\examples{
z <- getuuid()
a <- uuid(z)
a
class(a)
}
\keyword{classes}
