.packageName <- "ontoTools"
#
# very primitive approach because RBGL is not
# in windows yet.  but would like to have validation
# of DAG structure at construction time

require(graph)
setClass("rootedDAG", 
	representation(root="character", DAG="graph"))
			
setGeneric("root", function(x)standardGeneric("root"))
setMethod("root", "rootedDAG", function(x) x@root)
setGeneric("DAG", function(x)standardGeneric("DAG"))
setMethod("DAG", "rootedDAG", function(x) x@DAG)
setGeneric("getMatrix", function(g,type,mode)
	standardGeneric("getMatrix"))
setMethod("getMatrix", c("rootedDAG", "character", "character"),
	function(g,type,mode) {
		if (type != "child2parent") 
			stop("only type 'child2parent' supported")
		if (mode == "dense")
			return(child2parentMatDense(DAG(g)))
		if (mode == "sparse")
			return(child2parentMatSparse(DAG(g)))
		else stop("mode must be 'sparse' or 'dense'")
	})
	
child2parentMatDense <- function(g) {
 nd <- nodes(g)
 el <- edges(g)
 tails <- names(el)
 out <- matrix(0,nr=length(nd),nc=length(nd))
 dimnames(out) <- list(nd,nd)
 for (tl in tails)
   {
   for (tip in el[[tl]])
     out[tl,tip] <- 1
   }
 out
}

child2parentMatSparse <- function(g) 
{
    require(SparseM)
    nd <- nodes(g)
    mape <- new.env(hash = TRUE)
    for (i in 1:length(nd)) assign(nd[i], i, env = mape)
    map <- function(tag) get(tag, env = mape)
    el <- edges(g)
    tails <- names(el)
    sinit <- makeSparseZero(length(nd), length(nd))#as.matrix.csr(0, nrow = length(nd), ncol = length(nd))
    i <- 0
    for (tl in tails) {
        i <- i + 1
        if (i%%250 == 0) 
            cat(i)
        for (tip in el[[tl]]) if (!is.na(tip)) 
            sinit[map(tl), map(tip)] <- 1
    }
    sinit
}

#setMethod("depth", c("rootedDAG","missing"), function(x,maxd=50) {
# mat <- getMatrix(x, "child2parent", "sparse")
# d <- 0
# tmp <- mat
# while (maxval(tmp) > 0) 
#   {
#   d <- d+1
#   tmp <- tmp %*% mat
#   }
# d
#})
 
buildGOgraph <- function(useenv=GOMFPARENTS) {
 library(GO)
 library(Biobase)
 library(graph)
 nds <- unique(ls(env=useenv))
 eds <- multiget( nds, env=useenv )
 eds <- lapply( eds, function(x) {
     lk <- match(x,nds)
     if (length(lk)==0) return(list(edges=character(0)))
     else if (length(lk)==1 && is.na(lk)) return(list(edges=character(0)))
     else if (any(is.na(lk))) return(list(edges=lk[!is.na(lk)]))
     return(list(edges=lk))
     })
 tmp <- new("graphNEL", nodes=nds, edgeL=eds, edgemode="directed")
 attr(tmp,"toolInfo") <- library(help=GO)$info[[2]][[2]]
 tmp
}

#
# eventually should be replaced by Rgraphviz calls
#

setClass("compoundGraph",
 representation(grList="list",
  between="list"))

setGeneric("grList",function(object)standardGeneric("grList"))
setMethod("grList","compoundGraph", function(object)object@grList)

setGeneric("between",function(object)standardGeneric("between"))
setMethod("between", "compoundGraph", function(object)object@between)

setGeneric("toDot", function(G, outDotFile, renderList, optList)standardGeneric("toDot"))
setMethod("toDot", c("graphNEL", "character", "list", "list"),
function (G, outDotFile, renderList, optList=.standardToDotOptions) 
{

buildEdge <- function(fromTok, toTok, opts, labField=NULL) {
 protq <- function(x) paste("\"",x,"\"",sep="")
 core <- paste(protq(fromTok),"->",protq(toTok),";\n",sep=" ")
 UDB <- opts$useDirBack
 ELF <- opts$edgeLabelField
 if (length(UDB) == 0) UDB <- FALSE
 if (length(ELF) == 0 || nchar(ELF) == 0 || is.null(labField)) ELF <- FALSE
   else ELF <- TRUE
 if (!UDB & !ELF) return(core)
 if (UDB & !ELF) return( paste("edge [dir=back]", core, sep=" "))
 if (!UDB & ELF) return( paste("edge [label=", labField,"] ", 
          core, sep=""))
 if (UDB & ELF) return( paste("edge [dir=back label=", 
          labField,"] ", core, sep=""))
 stop("logic error")
 }

 
# to get bottom to top orientation (B points up to A), use [dir=back] A->B
#
    if (is.null(renderList$start)) renderList$start <- "digraph G"
    out <- paste(renderList[["start"]], " {\n", sep="")
    ned <- length(E <- edgeL(G))
    enms <- names(E)
    nds <- nodes(G)
    ac <- as.character
    if (!is.null(pn <- renderList[["prenodes"]]))
       out <- paste(out, pn, "\n")
# need quote marks
    protq <- function(x) paste("\"",x,"\"",sep="")
# this takes care of isolated nodes if present
    for (j in nds) out <- paste( out, protq(j), ";\n" )
# deal with an edge statement
    if (!is.null(pe <- renderList[["preedges"]]))
       out <- paste(out, pe, "\n")
 if (ned > 0)
    for (i in 1:ned) 
      {
      if ((L <- length(E[[i]]$edges)) > 0)
        for (j in 1:L)
        {
        out <- paste(out, buildEdge( from=nds[ E[[i]]$edges[j] ],
         to=enms[i], optList, E[[i]][[ optList$edgeLabelField ]] ), sep=" ")
        }
      }
    out <- paste(out, "}\n", sep = "", collapse = "")
    if (outDotFile != ".AS.STRING")
      {
      cat(out, file = outDotFile)
      paste("dot file written to", 
           outDotFile, " use 'dot -Tps [.dot] [.ps] to render.\n")
      invisible(0)
      }
    else out
})

setMethod("toDot", c("graphNEL", "character", "missing", "missing"),
 function(G, outDotFile, renderList, optList) toDot(G, outDotFile, list(start="digraph G"), .standardToDotOptions))
# where=where)

setMethod("toDot", c("graphNEL", "missing", "missing", "missing"),
 function(G, outDotFile, renderList, optList) toDot(G, , list(start="digraph G"), .standardToDotOptions))
 #where=where)

setMethod("toDot", c("graphNEL", "missing", "character", "missing"),
 function (G, outDotFile, renderList, optList) toDot(G, ".AS.STRING", list(start=renderList," "), .standardToDotOptions))
# where=where)
 
setMethod("toDot", c("graphNEL", "missing", "list", "list"),
 function(G, outDotFile, renderList, optList) toDot(G, ".AS.STRING" , renderList, optList))
# where=where)

setMethod("toDot", c("graphNEL", "missing", "list", "missing"),
 function(G, outDotFile, renderList, optList) toDot(G, ".AS.STRING" , renderList, .standardToDotOptions))
# where=where)

setMethod("toDot", c("graphNEL", "missing", "missing", "list"),
 function(G, outDotFile, renderList, optList) toDot(G, ".AS.STRING" , list(start="digraph G"), optList))
# where=where)

setMethod("toDot", c("graphNEL", "character", "missing", "list"),
 function(G, outDotFile, renderList, optList) toDot(G, outDotFile , list(start="digraph G"), optList))
# where=where)


#function (G, outDotFile, start, optList) 
#{
## fakes structure to get bottom to top orientation
#    startStr <- start[[1]]
#    ext <- start[[2]]
#    out <- paste(startStr, " {\n", ext, sep="")
#    ned <- length(E <- edgeL(G))
#    enms <- names(E)
#    nds <- nodes(G)
## this takes care of isolated nodes if present
#    for (j in nds) out <- paste( out, j, ";\n" )
#    for (i in 1:ned) 
#    ac <- as.character
#    for (i in 1:ned) 
#      {
#      if ((L <- length(E[[i]]$edges)) > 0)
#        for (j in 1:L)
#        {
#        out <- paste(out, " edge [dir=back] \"", nds[ E[[i]]$edges[j] ],
#        "\"->\"", enms[i], "\";\n", sep = "", collapse = "")
#        }
#      }
#    out <- paste(out, "}", sep = "", collapse = "")
#    #cat(out, file = outDotFile)
#    #paste("dot file written to", outDotFile, " use 'dot -Tps [.dot] [.ps] to render")
#    out
#})

setMethod("toDot", c("compoundGraph", "character", "list", "missing"),
function(G, outDotFile, renderList, optList) toDot(G, outDotFile, renderList,
  .standardToDotOptions))

setMethod("toDot", c("compoundGraph", "missing", "list", "missing"),
function(G, outDotFile, renderList, optList) toDot(G, ".AS.STRING", renderList,
  .standardToDotOptions))

setMethod("toDot", c("compoundGraph", "character", "list", "list"),
function(G, outDotFile, renderList, optList) {
# here renderList is a compound renderlist, one renderList per
# element of compound graph.  this list of renderlists
# must have something like "subgraph cluster_" as start
   ng <- length( GL <- grList(G) )
   rendL <- renderList #compRenderList(G)
   out <- "digraph G {\n"
   start <- rendL[[1]]$start
   if (is.null(start)) start <- "subgraph cluster_"
   sgn <- paste(start,1:ng,sep="")
   for (i in 1:ng)
     {
     if (length(rendL) == 0) ext <- NULL
       else ext <- rendL[[i]]
     out <- paste(out, toDot(GL[[i]],,
              list( start=paste(sgn[i],"\n",sep=""),
                    prenodes=ext$prenodes, preedges=ext$preedges), optList)
                 ,sep="")
     }
#
# done with subgraphs, now deal with between stuff
#
   if (!is.null(rendL[[i+1]]))
      out <- paste(out, rendL[[i+1]]$preedges)
   if ((L <- length(BG <- between(G))) > 0)
        for (j in 1:L)
        {
        out <- paste(out, " edge [dir=back] \"", BG[[ j ]][2],
        "\"->\"", BG[[ j ]][1], "\";\n", sep = "", collapse = "")
        }
   out <- paste(out, "}\n", sep = "", collapse = "")
   cat(out, file = outDotFile)
   cat("dot file written to", outDotFile, " use 'dot -Tps [.dot] [.ps] to render\n")
})

setGeneric("adjMat",function(cg,ordvec)standardGeneric("adjMat"))
setMethod("adjMat", c("compoundGraph", "ANY"), function(cg, ordvec) {
 if (length(ordvec)>2) stop("must specify indices of source and sink in ordvec, length(ordvec)==2")
 arows <- nodes(grList(cg)[[ordvec[1]]])
 acols <- nodes(grList(cg)[[ordvec[2]]])
 adjm <- matrix(0, nr=length(arows), nc=length(acols))
 dimnames(adjm) <- list(arows,acols)
 for (arc in between(cg))
  adjm[arc[1], arc[2]] <- 1
 adjm
})
#}
 
.standardToDotOptions <- list( useDirBack=TRUE )

newadj <- function (object, index)
{
  if (length(index) > 1) stop("please use index of length 1")
  nd <- nodes(object)
  if (!(index %in% nd)) stop(paste("vertex",index,"not among nodes in graph"))
  ans <- NULL
# index is adjacent to each tip of each arc emanating from index
  tails <- names(el <- edges(object))
  if (index %in% tails) ans <- el[[index]]
# now see if index is the tip of any directed arc
  for (curtail in tails)
       if (index %in% el[[curtail]]) ans <- c(ans,curtail)
  unique(ans)
}

daughterMat <- function( g ) {
 nd <- nodes(g)
 el <- edges(g)
 tails <- names(el)
 out <- matrix(0,nr=length(nd),nc=length(nd))
 dimnames(out) <- list(nd,nd)
 for (tl in tails)
   {
   for (tip in el[[tl]])
     if (!is.na(tip)) # for root
     out[tl,tip] <- 1
   }
 out
}

DMdepth <- function (g, maxd=50) 
{
    d <- 0
    dt <- dt0 <- daughterMat(g)
    while (max(dt) > 0 & d < maxd) {
        d <- d + 1
        dt <- dt %*% dt0
    }
    if (d < maxd) return(d)
    else stop("max DMdepth encountered, reset DMdepth maxd parameter")
}

coverMat <- function( ooc, ordvec ) {
    onto <- ooc@grList[[ordvec[2]]]
    map <- adjMat(ooc,ordvec)
    dt <- daughterMat(onto)
    d <- DMdepth(onto)
    acc <- pmin(map + (tmp <- map %*% dt), 1)
    for (i in 2:d) {
        acc <- pmin(acc + (tmp <- tmp %*% dt), 1)
    }
    acc
}


daughterSpMat <- function( g ) {
 require(SparseM)
 nd <- nodes(g)
 map <- function(tag) (1:length(nd))[nd==tag]
 el <- edges(g)
 tails <- names(el)
 #init <- diag(length(nd))*0.
 sinit <- makeSparseZero(length(nd), length(nd))#as.matrix.csr(0,nrow=length(nd),ncol=length(nd))
 sinit@dimension[1] <- as.integer(length(nd))
 sinit@dimension[2] <- as.integer(length(nd))
 #dimnames(out) <- list(nd,nd)
 for (tl in tails)
   {
   for (tip in el[[tl]])
     sinit[map(tl), map(tip)] <- 1
   }
 sinit
}


makeSparseZero <- function(nr,nc)
 {
 require(SparseM)
 new("matrix.csr", ra = 0, ja = as.integer(1), ia = as.integer(c(1:1,  
    rep(2, nr))), dimension = as.integer(c(nr,nc)))
 }

if (!exists("multiget")) multiget <- function (x, pos = -1, envir = as.environment(pos), mode = "any", 
    inherits = TRUE, iffail = NA) 
{
    lenx <- length(x)
    ans <- vector("list", length = lenx)
    if (!is.environment(envir)) 
        stop("envir argument is not an environment")
    options(show.error.messages = FALSE)
    on.exit(options(show.error.messages = TRUE))
    for (i in 1:lenx) if (is.list(x)) 
        ans[[i]] <- try(get(x[[i]], pos, envir, mode, inherits))
    else ans[[i]] <- try(get(x[i], pos, envir, mode, inherits))
    options(show.error.messages = TRUE)
    on.exit(NULL)
    failfun <- function(x) {
        cx <- class(x)
        if (!is.null(cx) && cx == "try-error") 
            TRUE
        else FALSE
    }
    failed <- sapply(ans, failfun)
    ans[failed] <- iffail
    names(ans) <- x
    ans
}


#slow method of summing a sparse matrix
sumSpSLOW <- function(x) {
 s <- 0
 nr <- dim(x)[1]
 for (i in 1:nr) {
  if (i %% 250 == 0) cat(i)
  s <- s + as.matrix(x[i,])
 }
 s
}

colSumsSp <- function(x) {
# columnwise sums of a sparse matrix
 s <- 0
 nc <- dim(x)[2]
 nr <- dim(x)[1]
 unit <- as.matrix.csr(rep(1.0,nr),nrow=1,ncol=nr)
 as.double(as.matrix(unit %*% x))
 }
 
rowSumsSp <- function(x) {
# rowwise sums of a sparse matrix
 s <- 0
 nc <- dim(x)[2]
 nr <- dim(x)[1]
 unit <- as.matrix.csr(rep(1.0,nc),nrow=nc,ncol=1)
 as.double(as.matrix(x %*% unit))
 }

sumSp <- function(x) {
# sum of sparse matrix elements
 sum(colSumsSp(x))
}

mapNamesInds <- function(cvec) {
 inds <- 1:length(cvec)
 n2imap <- new.env(hash=TRUE)
 i2nmap <- new.env(hash=TRUE)
 for (i in inds)
  {
  assign(cvec[i], i, env=n2imap)
  assign(as.character(i), cvec[i], env=i2nmap)
  }
 list(n2i=n2imap, i2n=i2nmap)
}

require(SparseM)
#setClass("mapStruct", representation(from="character",
#		to="character", forward="environment",
#		reverse="environment"))
#
#
# not happy with this stuff .... need to really
# transparently attach dimnames to sparse matrix
# don't want to do too much because the authors will probably
# do it
#

mkNS <- function(sm)
 {
 d <- dim(sm)
 rn <- letters[1:d[1]]
 cn <- LETTERS[1:d[2]]
 new("namedSparse", mat=sm, Dimnames=list(rn,cn), rowindex=
     mapNamesInds(rn), colindex=mapNamesInds(cn))
 }


setClass("namedSparse", 
	representation(Dimnames="list", mat="matrix.csr",
		rowindex="list", colindex="list"))

#setGeneric("setNames", function(x,rown,coln) standardGeneric("setNames"))
#setMethod("setNames", c("matrix.csr","character", "character"),
#	function(x,rown,coln) {
#		new("namedSparse",
#			Dimnames=list(rown,coln),
#			mat=x,
#			rowindex=mapNamesInds(rown),
#			colindex=mapNamesInds(coln))
#	})

setMethod("dimnames<-", c("namedSparse","list"), function(x,value) {
 new("namedSparse", Dimnames=value, mat=x@mat, rowindex=mapNamesInds(value[[1]]),
 colindex=mapNamesInds(value[[2]]))})

setGeneric("mat", function(x)standardGeneric("mat"))
setMethod("mat", "namedSparse", function(x) x@mat)
setGeneric("nrow", function(x)standardGeneric("nrow"))
setMethod("nrow", "namedSparse", function(x) nrow(mat(x)))
setGeneric("ncol", function(x)standardGeneric("ncol"))
setMethod("ncol", "namedSparse", function(x) ncol(mat(x)))
#setGeneric("Dimnames", function(x)standardGeneric("Dimnames"))
setMethod("dimnames", "namedSparse", function(x) x@Dimnames)
setGeneric("rowindex", function(x)standardGeneric("rowindex"))
setMethod("rowindex", "namedSparse", function(x) x@rowindex)
setGeneric("colindex", function(x)standardGeneric("colindex"))
setMethod("colindex", "namedSparse", function(x) x@colindex)

		
#setGeneric("as.matrix", function(x)standardGeneric("as.matrix"))
setMethod("as.matrix", "namedSparse", function(x) {
  dd <- dim(mat(x))
  if (max(dd) > 20) stop("not coercing sparse mat with dim>20...do it manually")
  M <- as.matrix(x@mat)
  dimnames(M) <- dimnames(x)
  M
})

as.matrix.ok <- function(x) {
  #dd <- dim(mat(x))
  #if (max(dd) > 20) stop("not coercing sparse mat with dim>20...do it manually")
  M <- as.matrix(x@mat)
  dimnames(M) <- dimnames(x)
  M
}

AMN <- function(x) {
  dd <- dim(mat(x))
  if (max(dd) > 20) stop("not coercing sparse mat with dim>20...do it manually")
  M <- as.matrix(mat(x))
  dimnames(M) <- dimnames(x)
  M
}
 
setMethod("[", "namedSparse", def=function(x, i, j, ..., drop=FALSE) {
	exns(x, i, j ,..., drop=drop) })

exns <- function(x, i, j, ..., drop=FALSE) {
  # current SparseM does not use drop, ignore
  # sparseM does not know about boolean indexing
	umget <- function(x,env) unlist(multiget(x,env))
	if (missing(j)) {
		if (missing(i)) return(x)  # missing i and j, RETURN
		coln <- dimnames(x)[[2]]   # have i but not j, compute coln
		colinds <- 1:length(coln)
     		if (is.numeric(i)) rowinds <- i # need to decode i
			else if (is.logical(i)) rowinds <- (1:nrow(x))[i]
			else if (is.character(i)) rowinds <- umget(i,env=rowindex(x)[["n2i"]])
			else stop(paste("cannot handle index of class",class(i)))
		rown <- dimnames(x)[[1]][rowinds]
		}
  	else {     # have j, don't know about i
     		if (is.numeric(j)) colinds <- j  # decode j
			else if (is.logical(j)) colinds <- (1:ncol(x))[j]
			else if (is.character(j)) colinds <- umget(j,env=colindex(x)[["n2i"]])
			else stop(paste("cannot handle index of class",class(j)))
		coln <- dimnames(x)[[2]][colinds]
		if (missing(i)) {  # have j but no i, RETURN with j restrict
			return(new("namedSparse", mat=mat(x)[,colinds],
				Dimnames=list(dimnames(x)[[1]], coln),
				rowindex=rowindex(x),
				colindex=mapNamesInds(coln)))
			}  # now have i and j, need to decode i
     		if (is.numeric(i)) rowinds <- i # need to decode i
			else if (is.logical(i)) rowinds <- (1:nrow(x))[i]
			else if (is.character(i)) rowinds <- umget(i,env=rowindex(x)[["n2i"]])
			else stop(paste("cannot handle index of class",class(i)))
		rown <- dimnames(x)[[1]][rowinds]
	     }
		return(new("namedSparse", mat=mat(x)[rowinds,colinds],
			Dimnames=list(rown, coln),
			rowindex=mapNamesInds(rown),
			colindex=mapNamesInds(coln))) 
}

#library(SparseM)
#example(matrix.csr)
#AA <- A.csr
#NN <- mkNS(AA)

setGeneric("colSums" , function(x,na.rm=FALSE,dims=1)standardGeneric("colSums"))
setGeneric("rowSums" , function(x,na.rm=FALSE,dims=1)standardGeneric("rowSums"))
setMethod("colSums", c("namedSparse", "missing", "missing"),
 function(x,na.rm=FALSE,dims=1) {
  ans <- colSumsSp(mat(x))
  names(ans) <- dimnames(x)[[2]]
  ans
})
setMethod("rowSums", c("namedSparse", "missing", "missing"),
 function(x,na.rm=FALSE,dims=1) {
  ans <- rowSumsSp(mat(x))
  names(ans) <- dimnames(x)[[1]]
  ans
})

setMethod("Arith", c("namedSparse", "namedSparse"), function(e1,e2)
	stop("that method for namedSparse not implemented yet"))
# sparseM guys did not use e1 e2 convention
setMethod("%*%", c("namedSparse", "namedSparse"), 
	function(x,y) 
	new("namedSparse", mat=mat(x)%*%mat(y), Dimnames=list(
		dimnames(x)[[1]], dimnames(y)[[2]]),
		rowindex=mapNamesInds(dimnames(x)[[1]]),
		colindex=mapNamesInds(dimnames(y)[[2]])))


#addsp <- function(x,y) {
#locMCSRaddsub(x,y,1)
#}
#setGeneric("addnsp", function(e1,e2)standardGeneric("addnsp"))
setMethod("+", c("namedSparse", "namedSparse"), function(e1,e2) 
        {
	new("namedSparse", mat=mat(e1)+ mat(e2),
		Dimnames=list(
		dimnames(e1)[[1]], dimnames(e1)[[2]]),
		rowindex=mapNamesInds(dimnames(e1)[[1]]),
		colindex=mapNamesInds(dimnames(e1)[[2]]))
        })


setGeneric("maxval",function(x)standardGeneric("maxval"))
setMethod("maxval", "matrix.csr", function(x)
 {
 nr <- nrow(x)
 mx <- (-Inf)
 for (i in 1:nr) 
  mx <- max(c(mx,as.matrix(x[i,])))
 mx
 })
 
assign("%+%", function(x,y) {
 tmp <- x+y
 tmp@ra <- pmin(tmp@ra,1)
 tmp
})

setMethod("show", "namedSparse", function(object) {
 cat("named sparse matrix of dim")
 print(dim(mat(object)))
 nn <- dimnames(object)
 if (nrow(object)>4 | ncol(object)>4)
 {
  cat("northwest 4x4:\n")
  tmp <- as.matrix(object@mat[1:4,1:4])
  dimnames(tmp) <- list(nn[[1]][1:4], nn[[2]][1:4])
  print(tmp)
 }
 else {
   tmp <- as.matrix(object@mat)
   dimnames(tmp) <- list(nn[[1]], nn[[2]])
   print(tmp)
 }
})


setMethod("t", "namedSparse", function(x) {
 tmp <- t(mat(x))
 tmp <- mkNS(tmp)
 dimnames(tmp) <- dimnames(x)[2:1]
 tmp
})

makeNamedSparse <- function(sm,rn,cn)
 {
 d <- dim(sm)
 if (length(rn)!=d[1]) stop("number of row names does not match dim(sm)[1]")
 if (length(cn)!=d[2]) stop("number of column names does not match dim(sm)[2]")
 new("namedSparse", mat=sm, Dimnames=list(rn,cn), rowindex=
     mapNamesInds(rn), colindex=mapNamesInds(cn))
 }
setClass("ontology",
	representation(name="character",
			version="character",
			rDAG="rootedDAG"))
setGeneric("name", function(x)standardGeneric("name"))
setMethod("name", "ontology", function(x)x@name)
setGeneric("OVersion", function(x)standardGeneric("OVersion"))
setMethod("OVersion", "ontology", function(x)x@version)
setGeneric("rDAG", function(x)standardGeneric("rDAG"))
setMethod("rDAG", "ontology", function(x)x@rDAG)
setMethod("show", "ontology", function(object){
	cat(paste("Ontology object ",name(object),", version ",
		OVersion(object),"\n",sep=""))
	cat(paste(" root=",root(rDAG(object))),"\n")
	nterms <- length(tm <- nodes(DAG(rDAG(object))))
	if (nterms > 20) 
		{
		cat(" First 20 terms:\n")
		tm <- tm[1:20]
		}
	else cat(" Terms:\n")
	print(tm)
	}
)

makeOntology <- function( name, version, graph, root ) 
 new("ontology", name=name, version=version, rDAG=
             new("rootedDAG", root=root, DAG=graph))

setGeneric("accessMat", function(object)standardGeneric("accessMat"))
setMethod("accessMat", "ontology", function(object) {
	g <- rDAG(object)
	gm <- getMatrix(g, "child2parent", "sparse")
	d <- max(ontoDepth(g)) #DMdepth(DAG(g),maxd=200)
	tmp <- gm
	for (i in 1:(d-1))
		{
		tmp <- tmp + tmp %*% gm
		tmp@ra <- pmin(1,tmp@ra)
		}
	tmp2 <- new("namedSparse", mat=tmp)
	dimnames(tmp2) <- list(nodes(DAG(g)), nodes(DAG(g)))
	tmp2
	}
)

setClass("OOC",representation(ontology="ontology",
	OOmap="namedSparse"))
setGeneric("ontology",function(x)standardGeneric("ontology"))
setMethod("ontology","OOC",function(x)x@ontology)
setGeneric("OOmap",function(x)standardGeneric("OOmap"))
setMethod("OOmap","OOC",function(x)x@OOmap)
setMethod("show", "OOC", function(object) {
cat("object-ontology complex with ontology:\n")
	show(ontology(object))
cat("object-ontology map:\n")
	show(OOmap(object))
})
makeOOC <- function(ont,map)
 new("OOC", ontology=ont, OOmap=map)
	
setGeneric("coverageMat", function(x) standardGeneric("coverageMat"))
setMethod("coverageMat", "OOC", function(x) 
 {
	too <- OOmap(x)
	tmp <- 	too + (too %*% accessMat(ontology(x)))
    	tmp@mat@ra <- pmin(1,tmp@mat@ra)
    	tmp
})

ontoDepth <- function (rg) 
{
    g <- DAG(rg)
    R <- root(rg)
    nd <- nodes(g)
#    rg <- revArcs(g)
    dvec <- rep(NA, length(nd))
    names(dvec) <- nd
    tls <- names(eg <- edges(g))
    lel <- unlist(lapply(eg, length))
    tls <- rep(tls, lel)
    tps <- unlist(edges(g))
    ntps <- tls
    names(ntps) <- tps
    ntps <- ntps[!is.na(names(ntps))] # some roots have it
    dvec[R] <- 0
    dvec[ntps[names(ntps) == R]] <- 1
lastdone <- 1
while (any(is.na(dvec)))
   {
    dvec[ntps[names(ntps) %in% names(dvec[dvec == lastdone])]] <- lastdone+1
   lastdone <- lastdone+1
   }
    dvec
}

depthStruct <- function(rg)
{
dvec <- ontoDepth(rg)
tag2depth <- new.env(hash=TRUE)
depth2tags <- new.env(hash=TRUE)
nms <- names(dvec)
dps <- as.numeric(dvec)
for (i in 1:length(nms))
 {
 assign(nms[i], dps[i], env=tag2depth)
 }
for (d in 0:max(unique(round(dps,0))))
 {
 assign(as.character(d), nms[round(dvec,0)==d], env=depth2tags)
 }
list(tag2depth=function(x) get(x,env=tag2depth),
     depth2tags=function(x) get(as.character(x), env=depth2tags))
}
otkvEnv2namedSparse <- function(obs, tms, otkvEnv) {
#
# object-term key-value environment converted to
# named sparse matrix
# 
# very slow for large matrices!
#
require(SparseM)
# object term key-value list
# args seem excessive but need to account for a list that doesn't map to all terms
lnames <- ls(env=otkvEnv)
if (!(all(lnames %in% obs))) stop("some kvlist names not in obs vec")
rowind <- mapNamesInds(obs)
colind <- mapNamesInds(tms)
rf <- function(x) get(x,env=rowind[["n2i"]])
cf <- function(x) unlist(multiget(x,env=colind[["n2i"]]))
mat <- makeSparseZero(length(obs), length(tms))# as.matrix.csr(0.0,nrow=length(obs),ncol=length(tms))
for (i in 1:length(lnames))
 {
 if (i %% 100 == 0) cat(i)
 curob <- lnames[i]
 rind <- rf(curob)
 targc <- cf(get(curob,env=otkvEnv))
 for (j in 1:length(targc))
    {
    cind <- targc[j]
    if (is.na(cind) | is.na(rind)) next
    mat[ rind, cind ] <- 1.0
    }
 }
new( "namedSparse", mat=mat, Dimnames=list(obs,tms), rowindex=rowind, 
 colindex=colind)
}

otkvList2namedSparse <- function(obs, tms, otkvlist) {
require(SparseM)
# object term key-value list
# args seem excessive but need to account for a list that doesn't map to all terms
lnames <- names(otkvlist)
if (!(all(lnames %in% obs))) stop("some kvlist names not in obs vec")
rowind <- mapNamesInds(obs)
colind <- mapNamesInds(tms)
rf <- function(x) get(x,env=rowind[["n2i"]])
cf <- function(x) unlist(multiget(x,env=colind[["n2i"]]))
mat <- makeSparseZero(length(obs), length(tms))# as.matrix.csr(0.0,nrow=length(obs),ncol=length(tms))
for (i in 1:length(otkvlist))
 {
 if (i %% 100 == 0) cat(i)
 curob <- lnames[i]
 rind <- rf(curob)
 targc <- cf(otkvlist[[curob]])
 for (j in 1:length(targc))
    {
    cind <- targc[j]
    if (is.na(cind) | is.na(rind)) next
    mat[ rind, cind ] <- 1.0
    }
 }
new( "namedSparse", mat=mat, Dimnames=list(obs,tms), rowindex=rowind, 
 colindex=colind)
}
revArcs <- function (g) 
{
    tls <- names(eg <- edges(g))
    lel <- unlist(lapply(eg,length))
    tls <- rep(tls,lel)
    tps <- unlist(edges(g))
    ng <- nodes(g)
    nnod <- length(nodes(g))
    tmp <- lapply(split(tls, tps), function(x) list(edges = match(x, 
        ng)))
    full <- list()
    for (i in 1:nnod)
        full[[ ng[i] ]] <- list( edges=tmp[[ ng[i] ]]$edges )
    new("graphNEL", nodes = nodes(g), edgeL = full, edgemode = "directed")
}

#
# code to implement ideas from Lord et al Semantic similarity paper
#

usageCount <- function (map, acc, inds) 
{
    maptms <- dimnames(map)[[2]]
    acctms <- dimnames(acc)[[2]]
    usages <- rep(0,length(maptms))
    names(usages) <- maptms
#<<<<<<< semsim.R
#   cat(paste("progress (out of", nrow(MAP),"terms):"))
#   for (i in 1:nrow(MAP)) {
#======
    if (is.null(inds)) inds <- 1:nrow(map)
    cat(paste("progress in (", min(inds),",", max(inds),"):\n"))
    for (i in inds) {
#>>>>>> 1.3
        if ((i %% 5) == 0) cat(i)
        if ((i %% 200) == 0) cat("\n")
        hits <- maptms[as.matrix.ok(map[i, ]) == 1]
        if (length(hits)==0) next
        usages[hits] <- usages[hits] + 1
        for (j in 1:length(hits)) {
            anctags <- acctms[as.matrix.ok(acc[hits[j], ]) == 1]
            usages[anctags] <- usages[anctags] + 1
        }
    }
    tmp <- usages
    attr(tmp,"inds") <- inds
    tmp
}

conceptProbs <- function(ooc,acc=NULL,inds=NULL) {
 if (class(ooc) != "OOC") stop("arg must have class OOC")
 oom <- OOmap(ooc)
 if (is.null(acc)) acc <- accessMat(ontology(ooc))
 pc <- usageCount(oom, acc, inds)
 tmp <- pc/max(pc)
 attr(tmp,"inds") <- inds
 tmp
}

subsumers <- function(c1, c2, ont, acc=NULL) {
 if (class(ont) != "ontology") stop("ont must have class ontology")
 if (is.null(acc)) acc <- accessMat(ont)
 tmp <- colSums(acc[c(c1,c2),])
 names(tmp[tmp==2])
}

pms <- function(c1, c2, ooc, acc=NULL, pc=NULL) {
 #probability of minimum subsumer
 if (class(ooc) != "OOC") stop("arg must have class OOC")
 if (any(!(c(c1,c2) %in% nodes(DAG(rDAG(ontology(ooc))))))) 
     stop("some term not found in ontology DAG nodes")
 S <- subsumers(c1,c2,ontology(ooc),acc)
 if (is.null(pc)) pc <- conceptProbs(ooc,acc,pc)
 min(pc[S])
}

semsim <- function(c1, c2, ooc, acc=NULL, pc=NULL) 
 -log(pms(c1,c2,ooc,acc,pc))


