\name{analyseMA}
\alias{analyseMA}

\title{ANALYSIS OF FACTORIAL MICROARRAY EXPERIMENTS}
\description{
analyseMA is used for the ananlysis of factorial two-colour microarray experiments based
on the experimental design, a user-defined matrix containing the experimental question in
contrast form and a vector to discern vectorial contrasts from contrasts given in matrix
form. 
}
\usage{
analyseMA( data, design, id, cmat, cinfo, padj=c("none","bonferroni","fdr"), tol=1e-06 ) 
}

\arguments{
  \item{data}{ a matrix of size \eqn{G \times N} containing the normalized and/or standardized
data to be analyzed, where G is the number of spots under investigation and N is the
number of arrays used in the experiment. The matrix should contain one row for each spot.
The matrix should contain as many columns as arrays involved in the experiment, such that
each column contains the data for one single array. The matrix should not contain any ID variables, 
which are entered separately. Missing values should be entered as NA.}
  \item{design}{ the design matrix of size \eqn{N \times (K+2)}, where K is the number of
experimental conditions. This is the design matrix X known from linear model theory and
its elements are typically 0, 1, or -1. A 0 means that the associated parameter does not
apply for the corresponding observation (i.e., row). The first two columns are reserved
for the two dyes and are usually filled up with 1 and -1, respectively. }
  \item{id}{an ID vector of length G for the identification of the spots.}
  \item{cmat}{a matrix describing the p experimental questions (contrasts) to be analysed in
	the experiment. The matrix can be composed of vectorial contrasts (a single row of the
	matrix) and of contrasts in matrix form (several rows of the matrix),
	e.g. an \eqn{A \times B} interaction effect in a \eqn{3 \times 2} design. All
	contrasts have to be combined into one matrix (using rbind for instance). }
  \item{cinfo}{ a vector of length p describing the grouping of the contrast matrix rows in vector or matrix 
	form. E.g. if the design matrix contains three contrasts in vector form, cinfo =
	rep(1,3), if it contains two vectorial contratst and one as matrix with three rows,
	cinfo=c(1,1,3). }
  \item{padj}{a quoted string indicating the multiplicity adjustment that should be used.
"none" - no multiplicity adjustment, "bonferroni" - Bonferroni single step adjustment,
"fdr" - linear step-up procedure of Benjamini and Hochberg.}
  \item{tol}{A value indicating the tolerance for contrast estimability check }
}
\details{
  The analysis is perfomed separately for each spot. For each spot, arrays with NA values
are dropped. Then, for each experimental question (either contrast vector or contrast
matrix) a check on the estimabilty of the resulting linear function is done. If the linear
function of interest is estimable, t- or F-tests (whichever is appropriate) are computed
and the associated unadjusted $P-$values are computed. Multiplicity adjustment is done
over the number of spots only.
}
\value{
  a \eqn{G \times (4p+3)} matrix with the following row-wise components. 
  \item{(i)}{the first column contains the ID}
  \item{(ii)}{columns 2 though p+1 contain the estimates of the linear function (in case
of vectorial contrasts) or the dregrees of freedom for the quadratic form in the numerator
(in case of contrasts given in matrix form and that F-tests are used), depending on cinfo.}
  \item{(iii)}{columns p+2 through 2p+1 contain the test statistics (either t- or F-tests,
depending on cinfo)}
  \item{(iv)}{columns 2p+2 through 3p+1 contain the raw P-values, associated to the t- and
F-tests}
  \item{(v)}{column 3p+2 contains the mean square error}
  \item{(vi)}{column 3p+3 contains the residual degrees of freedom}
  \item{(vii)}{columns 3p+4 through 4p+3 contain the multiplicity adjusted P-values,
associated to the raw P-values, as long as a multiplicty adjustment method has been selected}
}
\references{Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
	two colour factorial microarray experiments", submitted.
	\url{http://www.microarrays.med.uni-goettingen.de/} 
}
\author{Jobst Landgrebe (jlandgr1@gwdg.de) and Frank Bretz (bretz@bioinf.uni-hannover.de) }
\note{}

\seealso{}
\examples{
	\dontrun{      result <-	analyseMA( data=data.3x2, design=designs.composite$BSBSBS, id=id.3x2,
		cmat=cmatB.AB, cinfo=c(1,3), padj=c("fdr"), tol=1e-06 ) # analyse a dataset with
									# 30012 spots and 18 arrays. The design
									# is 3x2 with 3 replicates, the
									# contrasts of interest are the main effect
									# B and the interaction effect AxB.
	}
}
\keyword{design}
\keyword{models}

\eof
\name{cinfo}
\alias{cinfo}
\docType{data}
\title{Vector indexing the matrix cmat}
\description{
This vector is used to describe the structure of the rows of the contrast
matrix cmat. The number of entries in cinfo mirrors the number of experimental
questions. "1" indicates a contrast in vectorial form, integers n > 1 indicate \eqn{n}
contrasts given in matrix form.
}
\usage{Such a vector has to be created for every contrast martix. sum(cinfo) has to be 
equal to nrow(cmat). }

\format{}
\details{}
\source{}
\references{
Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
        two colour factorial microarray experiments", submitted.
}
\examples{
data(cinfo)
}
\keyword{datasets}

\eof
\name{cinfoB.AB}
\alias{cinfoB.AB}
\docType{data}
\title{Vector indexing the matrix cmatB.AB}
\description{
This vector is used to describe the structure of the rows of the contrast matrix cmatB.AB
Its first element (1) indicates that the first esperimental question (main effect B) is described by a
single contrast in vectorial form. The second element (2)
indicates that the second experimental question (interaction between A and B) is given by
a contrast in matrix form.
}
\usage{Such a vector has to be created for every contrast martix.}
\format{ 
}
\details{
}
\source{
}
\references{
Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
        two colour factorial microarray experiments", submitted.
}
\examples{
data(cinfoB.AB)
}
\keyword{datasets}

\eof
\name{cmat}
\alias{cmat}
\docType{data}
\title{ Contrast matrix describing the experimental questions}
\description{
This matrix of numerical constants describes the experimental question, \eqn{p} say. Each experimental question is
described by a single contrast vector (a single row in cmat) or by a contrast matrix
(several rows in cmat). The ordering of the columns corresponds to that of the associated
design matrix X. Thus, typically the first two elements in a row of cmat are reserved for
for the two dyes. E.g. to compare the two dyes, we set (-1, 1, 0, ..., 0). 
}
\usage{data(cmat)}
\format{
}
\details{
}
\source{

}
\references{
Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
        two colour factorial microarray experiments", submitted.
}
\examples{
data(cmat)
## maybe str(cmat) ; plot(cmat) ...
}
\keyword{datasets}

\eof
\name{cmatB.AB}
\alias{cmatB.AB}
\docType{data}
\title{ Contrast matrix describing the experimental questions}
\description{
This matrix of numerical constants describes the experimental question,  say p. Each experimental question is
described by a single contrast vector (a single row in cmat) or by a contrast matrix
(several rows in cmat). The ordering of the columns corresponds to that of the associated
design matrix X. Thus, typically the first two elements in a row of cmat are reserved for
for the two dyes. E.g. the first line of the matrix cmatB.AB describes the main effect B.
}
\usage{data(cmatB.AB)}
\format{
}
\details{
}
\source{
}
\references{
Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
        two colour factorial microarray experiments", submitted.
}
\examples{
data(cmatB.AB)
}
\keyword{datasets}

\eof
\name{core}
\alias{core}
\title{Internal function of analyseMA}
\description{
This internal function of analyseMA computes the statistics and estimators
that are organised and given out by the main function analyseMA.
}
\usage{
core(vector, design, cmat, cinfo, tol)
}
\arguments{
  \item{vector}{a simple help variable for the apply call}
  \item{design}{ the design matrix of size \eqn{N \times (K+2)}, where K is the number of
experimental conditions. This is the design matrix X known from linear model theory and
its elements are typically 0, 1, or -1. A 0 means that the associated parameter does not
apply for the corresponding observation (i.e., row). The first two columns are reserved
for the two dyes and are usually filled up with 1 and -1, respectively. }
  \item{cmat}{a matrix describing the p experimental questions (contrasts) to be analysed in
	the experiment. The matrix can be composed of vectorial contrasts (a single row of the
	matrix) and of contrasts in matrix form (several rows of the matrix),
	e.g. an \eqn{A \times B} interaction effect in a \eqn{3 \times 2} design. All
	contrasts have to be combined into one matrix (using rbind for instance). }
  \item{cinfo}{ a vector of length p describing the grouping of the contrast matrix rows in vector or matrix 
	form. E.g. if the design matrix contains three contrasts in vector form, cinfo =
	rep(1,3), if it contains two vectorial contratst and one as matrix with three rows,
	cinfo=c(1,1,3). }
  \item{tol}{A value indicating the tolerance for contrast estimability check }
}
\details{
}
\value{
}
\references{Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
        two colour factorial microarray experiments", submitted.
	        \url{http://www.microarrays.med.uni-goettingen.de/}
		}
\author{Jobst Landgrebe (jlandgr1@gwdg.de) and Frank Bretz (bretz@bioinf.uni-hannover.de) }
\note{}

\seealso{}
\examples{}
\keyword{}

\eof
\name{data.3x2}
\alias{data.3x2}
\docType{data}
\title{3x2 microarray data}
\description{
These are data from a microarray
experiment in which the expression profiles of three cell lines were analysed
with and without drug treatment using cDNA microarrays spotted with 300012 human
cDNAs. The data matrix consists of 30012 rows and 18 columns. Each row represents one spot,
each column corresponds to one microarray. }
\usage{data(data.3x2)}
\format{
  The format is: matrix of size 30012 x 18.
}
\details{
}
\source{
cDNA microarray lab of the University of Goettingen, Germany.
\url{http://www.microarrays.med.uni-goettingen.de}
}
\references{
}
\examples{
data(data.3x2)
## maybe str(data.3x2) ; plot(data.3x2) ...
}
\keyword{datasets}

\eof
\name{designMA}
\alias{designMA}

\title{DESIGN OF FACTORIAL MICROARRAY EXPERIMENTS}

\description{designMA computes efficient factorial microarray experimental designs
	for two-colour microarrays based on a list of user-defined design matrices, a
	matrix describing the experimental questions (contrasts), a vector to discern
	vectorial contrasts from contrasts given in matrix form
	and a design optimality criterion.}

\usage{
designMA(design.list, cmat, cinfo, type = c("d", "e", "t"), tol = 1e-06)
}

\arguments{
  \item{design.list}{a named list of design matrices. Each design matrix should have nrow = number of
	arrays and ncol= number of experimental conditions. With p columns, the first two columns describe
	the dye labeling (green and red), the remaining columns describe the experimental 
	conditions.
	} 
  \item{cmat}{a matrix describing the experimental questions (contrasts) to be analysed in
	the experiment. The matrix can be composed of vectorial contrasts (a single row of the
	matrix) and of contrasts in matrix form (several rows of the matrix),
	e.g. an \eqn{A \times B} interaction effect in a \eqn{3 \times 2} design. All
	contrasts have to be combined into one matrix (using rbind for instance).
	}

  \item{cinfo}{ a vector describing the grouping of the contrast matrix rows in vector or matrix 
	form. E.g. if the design matrix contains three contrasts in vector form, cinfo =
	rep(1,3), if it contains two vectorial contratst and one as matrix with three rows,
	cinfo=c(1,1,3). }	

  \item{type}{a quoted letter indicating the optimality criterion that shoul be used. "d"
	- determinant, "e" - eigenvalue, "t" - trace.}

  \item{tol}{A value indicating the tolerance for contrast estimability check.}
}

\details{The choice of the optimality criterion influences the design defined as best. We
	propose the trace criterion because of its straightforward interpretability. For a
	detailed description of optimality criteria cf. Pukelsheim, F. "Optimal Design of
	Experiments", New York 1993.
}
\value{ a list with the following components
  \item{alleff}{a matrix giving the absolute efficiency values (cols) for each contrast
	(rows). NA if contrast is not estimatable.
       }
  \item{alleffrel}{a matrix giving the relative efficiency values (cols) for each
	contrast (rows). The values are obtained by dividing the absolute values by the
	by the maximal efficiency value for a given contrast. NA if contrast is not estimatable.
       }
  \item{alleffave}{a vector giving the average efficiency for each design  over all
	contrasts.}
  \item{effdesign}{the name of the design with the highest alleffave value.}
  \item{df}{a vector with the degrees of freedom of the F-statistics obtained by the designs.}
}

\references{Bretz, F and Landgrebe J and Brunner E (2003):"Design and analysis of
	two colour factorial microarray experiments", submitted.
	\url{http://www.microarrays.med.uni-goettingen.de/} 
}

\author{Jobst Landgrebe (jlandgr1@gwdg.de) and Frank Bretz (bretz@bioinf.uni-hannover.de) }

\note{}

\seealso{}

\examples{ 	\dontrun{designs.basic}	# look at typical basic designs
		\dontrun{designs.composite } #look at comlpex composite designs
		\dontrun{t.eff.3x2.B.AB <-  designMA(designs.composite,
				   	    cmatB.AB,cinfoB.AB,type="t")# compute design efficiencies for
									# a \eqn{3 \times 2} factorial experiment
									# using 18 microarrays and asking for 
									# the main effect B and the interaction effect \eqn{A \times B}
		}
		\dontrun{t.eff.3x2.all <-  designMA(designs.composite,
					 	    cmat,cinfo,type="t")
		 }							#compute design efficiencies design for
									# a \eqn{3 \times 2} factorial
									# experiment using 18
                                                                        # microarrays and asking for 
                                                                        # the the simple B
                                                                        # effects, the main effects
                                                                        # A, B and the interaction
                                                                        # effect \eqn{A  \times B}
}

\keyword{design}
\keyword{models}

\eof
\name{designs.basic}
\alias{designs.basic}
\docType{data}
\title{Basic designs for two-colour factorial 3 x 2 microarray data}
\description{ A list of matrices describing basic designs for two-colour factorial microarray data of
size 3 x 2. Matrix rows represent microarrays, matrix columns represent parameters. 
}
\usage{data(designs.basic)}
\format{
List of matrices of size 6 x 9.
}
\details{
The designs are abbreviated as in the paper (cf. source and references): 
BS - swap over B, AL - A loop,  XL - crossed loop,  CL - circle loop,  RS - star swap,  TL
- triangular loop, CR - common reference.
}
\source{
cDNA microarray lab of the University of Goettingen, Germany.
\url{http://www.microarrays.med.uni-goettingen.de}
}

\keyword{datasets}

\eof
\name{designs.composite}
\alias{designs.composite}
\docType{data}
\title{Composite designs for two-colour factorial 3 x 2 microarray data}
\description{A list of matrices describing composite designs for two-colour factorial
microarray data of size 3 x 2 using 18 microarrays each. The design matrices are made up of
basic designs. Matrix rows represent microarrays, matrix columns represent parameters.
}
\usage{data(designs.composite)}
\format{
List of 10 matrices of size 18 x 9.
}
\details{
The matrix names reflect the basic designs they are made up from. The first two digits of
the names abbreviated the first basic design, the second two the second design etc.
The basic design abbreviations are: BS - swap over B, AL - A loop, XL - crossed loop, CL -
circle loop, RS - star swap, TL - triangular loop, CR - common reference.
BSBSBS is a tripled basic BS design, CLCLTL is a double circle loop design combined with a
triangular design and so on.
}
\source{
cDNA microarray lab of the University of Goettingen, Germany.
\url{http://www.microarrays.med.uni-goettingen.de}
}

\examples{
data(designs.composite)
}
\keyword{datasets}

\eof
\name{id.3x2}
\alias{id.3x2}
\docType{data}
\title{A vector of length 30012 containing numeric identifiers of the genes from the
microarray dataset data.3x2.}
\description{
Cf. data.3x2
}
\usage{data(id.3x2)}
\format{
  The format is:
 num [1:30012] 12 24 108 120 204 216 300 312 396 408 ...
}
\details{
}
\source{
}
\references{
}
\examples{
data(id.3x2)
}
\keyword{datasets}

\eof
