\name{SD}
\alias{SD}
\alias{tableSD}
\alias{affycomp.figure7}
\alias{affycomp.compfig7}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{SD Assessment Functions}
\description{
  These functions create assessments, figures, and tables for expression
  standard errors}
\usage{
affycomp.figure7(l,main="Figure 7")
affycomp.compfig7(l,method.names=as.character(1:length(l)),
                  main="Figure 7")
tableSD(l,method.names=NULL)
}
\arguments{
  \item{l}{a list of lists with the necessary components to create the
    Figure. See details.}
  \item{method.names}{a character vector with the names of the
    expression measures methodologies being compared. }
  \item{main}{title of the Figure.}
}
\details{
  This uses the dilution data. The exprsets need to have standard error
  estimates in the \code{se.exprs} slot. Read the vignette for more
  details. The functions work similarly to those assessing expression
  measures.

  All these files need the result of \code{\link{assessSD}}
}
\value{Depends on the call.}
\author{Rafael A. Irizarry}
\examples{
data(rma.sd.assessment) ##this was produced with affycomp.assess
data(lw.sd.assessment) ##this one too
affycomp.compfig7(list(rma.sd.assessment,lw.sd.assessment))
affycomp.figure7(rma.sd.assessment)
}
\keyword{manip}



\eof
\name{affycomp.compfigs.auxiliary}
\alias{affycomp.compfigs.auxiliary}
\alias{affycomp.compfig2}
\alias{affycomp.compfig2b}
\alias{affycomp.compfig3}
\alias{affycomp.compfig4a}
\alias{affycomp.compfig4b}
\alias{affycomp.compfig4c}
\alias{affycomp.compfig5a}
\alias{affycomp.compfig5b}
\alias{affycomp.compfig5cdef}
\alias{affycomp.compfig5c}
\alias{affycomp.compfig5d}
\alias{affycomp.compfig5e}
\alias{affycomp.compfig5f}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Auxiliary functions to create comparitive Figures}
\description{
These functions are auxiliary function to
\code{\link{affycompPlot}}. These Figures are used to compare
expression measures. They take lists with components created by the
\code{\link{assessDilution}} and \code{\link{assessSpikeIn}}
functions.}
\usage{
affycomp.compfig2(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 2")

affycomp.compfig3(l, method.names = as.character(1:length(l)),
                  main = "Figure 3")

affycomp.compfig4a(l, method.names = as.character(1:length(l)),
                   add.legend = TRUE, main = "Figure 4a")

affycomp.compfig4b(l, method.names = as.character(1:length(l)),
                   add.legend = TRUE, main = "Figure 4b")

affycomp.compfig4c(l, method.names = as.character(1:length(l)),
                   add.legend = TRUE, rotate=TRUE, main = "Figure 4c")

affycomp.compfig5a(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5a", maxfp=100)

affycomp.compfig5b(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5b", maxfp=100)

affycomp.compfig5cdef(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5c", maxfp=100,
                  type=c("low","medlow","medhigh","high")

affycomp.compfig5c(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5c", maxfp=100)

affycomp.compfig5d(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5d", maxfp=100)

affycomp.compfig5e(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5e", maxfp=100)

affycomp.compfig5f(l, method.names = as.character(1:length(l)),
                  add.legend = TRUE, main = "Figure 5f", maxfp=100)


}
\arguments{
  \item{l}{a list of lists with the necessary components to create the
    Figure. See details.}
  \item{method.names}{a character vector with the names of the
    expression measures methodologies being compared. }
  \item{add.legend}{logical. If TRUE a legend is added.}
  \item{main}{title of the Figure.}
  \item{rotate}{in the case of compfig4c one can eiher show the actual
    local slopes or the bias (local slope minus 1).}
  \item{maxfp}{range of the false positives in ROC will be from 0 to \code{maxfp}}
  \item{type}{compfig5cdef is the engine for 5c, 5d, 5e, and
5f. \code{type} tells is which of these 4 to run.}
}
\details{
  These are similar to the functions defined in
  \code{\link{affycomp.figures.auxiliary}}. Main difference is that
  here you send lists with the result of the assessment functions as
  components. 
}
\value{
Figures are produced.
}
\author{Rafael A. Irizarry}
\examples{
data(rma.assessment)
data(mas5.assessment)
affycomp.compfig2(list(rma.assessment$Dilution,mas5.assessment$Dilution))
affycomp.compfig3(list(rma.assessment$Dilution,mas5.assessment$Dilution))
affycomp.compfig4a(list(rma.assessment$Signal,mas5.assessment$Signal))
affycomp.compfig4b(list(rma.assessment$Dilution,mas5.assessment$Dilution))
affycomp.compfig5a(list(rma.assessment$FC,mas5.assessment$FC))
affycomp.compfig5b(list(rma.assessment$FC2,mas5.assessment$FC2))
}
\keyword{hplot}% at least one, from doc/KEYWORDS











\eof
\name{affycomp.figures.auxiliary}
\alias{affycomp.figures.auxiliary}
\alias{affycomp.figure1}
\alias{affycomp.figure1b}
\alias{affycomp.figure2}
\alias{affycomp.figure2b}
\alias{affycomp.figure3}
\alias{affycomp.figure4a}
\alias{affycomp.figure4b}
\alias{affycomp.figure4c}
\alias{affycomp.figure5a}
\alias{affycomp.figure5b}
\alias{affycomp.figure5c}
\alias{affycomp.figure5d}
\alias{affycomp.figure5e}
\alias{affycomp.figure5f}
\alias{affycomp.figure6a}
\alias{affycomp.figure6b}
\title{Auxiliary functions to create Figures}
\description{
These functions are auxiliary function to
\code{\link{affycompPlot}}. These Figures are used to assess an
expression measure. They take components created by the
\code{\link{assessDilution}} and \code{\link{assessSpikeIn}}
functions. }
\usage{
affycomp.figure1(l,main="Figure 1",xlim=NULL,ylim=NULL)
affycomp.figure1b(l,main="Figure 1b",xlim=NULL,ylim=NULL)
affycomp.figure2(l,main="Figure 2")
affycomp.figure2b(l,main="Figure 2b")
affycomp.figure3(l, main = "Figure 3")
affycomp.figure4a(l, main = "Figure 4a")
affycomp.figure4b(l, main = "Figure 4b")
affycomp.figure4c(l, rotate=TRUE, main = "Figure 4c")
affycomp.figure5a(l, main = "Figure 5a",maxfp=100)
affycomp.figure5b(l, main = "Figure 5b",maxfp=100)
affycomp.figure5c(l, main = "Figure 5c",maxfp=100)
affycomp.figure5c(l, main = "Figure 5d",maxfp=100)
affycomp.figure5c(l, main = "Figure 5e",maxfp=100)
affycomp.figure5c(l, main = "Figure 5f",maxfp=100)
affycomp.figure6a(l, main = "Figure 6a",xlim = NULL, ylim = NULL)
affycomp.figure6b(l, main = "Figure 6b",xlim = NULL, ylim = NULL)
}
\arguments{
  \item{l}{A list with the necessary components to create the
    Figure. See details.}
  \item{main}{Title for the Figure.}
  \item{maxfp}{range of the false positives in ROC will be from 0 to \code{maxfp}}
  \item{xlim}{x-axis limits.}
  \item{ylim}{y-axis limits.}
  \item{rotate}{in the case of compfig4c one can eiher show the actual
    local slopes or the bias (local slope minus 1).}
}
\details{
Read the vignette for more details on what each Figure is. You can read
\code{\link{assessSpikeIn}} and \code{\link{assessDilution}} to see
which assessments are needed.
}
\value{
Figures are produced.
}
\author{Rafael A. Irizarry}
\examples{
%%some examples
%%the functions not shown in example need another assessment function
data(rma.assessment)
affycomp.figure1(rma.assessment$MA)
affycomp.figure2(rma.assessment$Dilution)
affycomp.figure3(rma.assessment$Dilution)
affycomp.figure4a(rma.assessment$Signal)
affycomp.figure4b(rma.assessment$Dilution)
affycomp.figure5a(rma.assessment$FC)
affycomp.figure5b(rma.assessment$FC2)
affycomp.figure6a(rma.assessment$FC)
affycomp.figure6b(rma.assessment$FC)
}
\keyword{hplot}

\eof
\name{affycompTable}
\alias{affycompTable}
\alias{tableAll}
\alias{tableDilution}
\alias{tableFC}
\alias{tableFC2}
\alias{tableSignal}
\alias{tableOverallSNR}
\alias{tableLS}

%- Also NEED an `\alias' for EACH other topic documented here.
\title{Expression Assessment Table}
\description{
  These functions takes as an argument the output of the asessment
  functions.
}
\usage{
affycompTable(...,Table=NULL,assessment.list=NULL,method.names=NULL)

tableAll(...,assessment.list=NULL,method.names=NULL)

tableDilution(l, method.names=NULL)

tableFC(l, method.names=NULL)

tableFC2(l, method.names=NULL)

tableSignal(l, method.names=NULL)

tableOverallSNR(...,assessment.list=NULL,method.names=NULL,ngenes=12626)

tableLS(...,assessment.list=NULL,method.names=NULL,ngenes=12626,rank=TRUE)
}
\arguments{
  \item{\dots}{lists produced by the assessment functions}
  \item{Table}{If \code{TableAll} was used one can send it through this argument}
  \item{assessment.list}{Alternatively, one can also send a list of lists produced by \code{\link{tableAll}}.}
  \item{method.names}{A character vector with the names of the
    epxression measure methodology.}
  \item{l}{list of assessments.}
  \item{rank}{if \code{TRUE} \code{tableLS} will present ranks instead
    of local slopes.}
  \item{ngenes}{when computing ranks, out of how many genes should we do it?}
}
\details{
  Read the vignette for more details on what the entries of the table
  are. \code{affycompTable} has a few entries per graph. \code{tableAll}
  has more entries. Once an
  assessment is used this function knows what to do. You can call any of
  the assessment functions described in \code{\link{assessSpikeIn}},
  \code{\link{assessDilution}} and \code{\link{assessSD}}.

  Note \code{tableLS} and \code{tableOverallSNR} work on the results
  from \code{\link{assessSpikeIn2}}.
  
}
\value{
A matrix. One column per each method and one row for each comparison.}
}
\author{Rafael A. Irizarry}
\examples{
data(rma.assessment) ##this was produced with affycomp.assess
data(mas5.assessment) ##this one too
tmp <- affycompTable(mas5.assessment,rma.assessment)
format(tmp,digit=2)
}
\keyword{manip}



\eof
\name{affycompPlot}
\alias{affycompPlot}
\alias{affycomp.figure.calls}
\alias{affycomp.compfigs.calls}
\alias{affycomp.figures}
\alias{affycomp.compfigs}
\title{Assessment Plots}
\description{
Function that makes assessment plot}
}
\usage{
affycompPlot(...,assessment.list=NULL,method.names=NULL,
             figure1.xlim=c(-4,15),figure1.ylim=c(-10,12),
             figure1b.xlim=c(-4,15),figure1b.ylim=c(-6,5),
             figure6a.xlim=c(-12,12),figure6a.ylim=c(-12,12),
             figure6b.xlim=c(-3,3),figure6b.ylim=c(-6,6))

affycomp.compfigs(l,method.names=NULL,
                  figure1.xlim=c(-4,15),figure1.ylim=c(-10,12),
                  figure1b.xlim=figure1b.xlim,figure1b.ylim=figure1b.ylim,
                  figure6a.xlim=c(-12,12),figure6a.ylim=c(-12,12),
                  figure6b.xlim=c(-3,3),figure6b.ylim=c(-6,6))
affycomp.figures(l)
affycomp.figure.calls(what)
affycomp.compfigs.calls(what)
}
\arguments{
    \item{\dots}{lists produced by the assessment functions (one for
    each method) separated by commas.}
  \item{assessment.list}{Alternatively, one can also send a list of
    lists produced by one of the assessment functions}.
  \item{method.names}{A character vector with the names of the
    epxression measure methodology.}
  \item{figure1.xlim}{x-axis lim used for the plots in Figure 1.}
  \item{figure1.ylim}{y-axis lim used for the plots in Figure 1.}
  \item{figure1b.xlim}{x-axis lim used for the plots in Figure 1b.}
  \item{figure1b.ylim}{y-axis lim used for the plots in Figure 1b.}
  \item{figure6a.xlim}{x-axis lim used for the plots in Figure 6a.}
  \item{figure6a.ylim}{y-axis lim used for the plots in Figure 6a.}
  \item{figure6b.xlim}{x-axis lim used for the plots in Figure 6b.}
  \item{figure6b.ylim}{y-axis lim used for the plots in Figure 6b.}
  \item{l}{list with assessment lists as components.}
  \item{what}{a dummy variable to know what function call to create.}
}

\details{
Read the vignette for more details on what each Figure is. Once an
assessment is used this function knows what to do. You can call any of
the assessment functions described in \code{\link{assessSpikeIn}},
\code{\link{assessDilution}} and \code{\link{assessSD}}.

\code{affycomp.figures}, \code{affycomp.figure.calls},
\code{affycomp.compfigs.calls} are auxiliary functions.
}
\value{
  Figures are produced.
}
\author{Rafael A. Irizarry}
\examples{
data(rma.assessment)
data(mas5.assessment)
affycompPlot(rma.assessment,mas5.assessment)
affycompPlot(rma.assessment$FC)
affycompPlot(rma.assessment$Dilution,mas5.assessment$Dilution)
affycompPlot(rma.assessment$Dilution,mas5.assessment$Dilution)
affycompPlot(rma.assessment$Signal,mas5.assessment$Signal)
affycompPlot(rma.assessment$Dilution,mas5.assessment$Dilution)
affycompPlot(rma.assessment$FC2,mas5.assessment$FC2)
}
\keyword{hplot}



\eof
\name{assessAll}
\alias{assessAll}
\alias{affycomp}
\title{Assessment functions}
\description{
  Assessment functions.
  Takes a couple of 
  \code{\link[Biobase]{exprSet-class}}, one for spike in another for the
  dilution and returns a list with necessary
  information to create assessment plots.}
\usage{
assessAll(d,s,method.name=NULL,verbose=TRUE)

affycomp(d,s,method.name=NULL,verbose=TRUE,return.it=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
    \item{d}{An \code{\link[Biobase]{exprSet-class}} containing
    the exrpession measures for the Gene Logic's dilution experiment.}
  \item{s}{An \code{\link[Biobase]{exprSet-class}} containing
    expression measures for the 
    Affymetrix's spike-in experiment.}
  \item{method.name}{Name of expression measure being assessed.}
  \item{verbose}{verbosity flag.}
\item{return.it}{if \code{TRUE} returns assessment lists.}  
}
\details{
  \code{assessAll} performs assessments for Figures 1-6. It is a wrapper
  for \code{assessDilution} and \code{assessSpikeIn}.

\code{affycomp} is a wrapper that does it all... including the plottitng
and creation of table.
}
\value{
  Lists with the necessary information to make the Figures.
}
\author{Rafael A. Irizarry}

\keyword{manip}



\eof
\name{assessDilution}
\alias{assessDilution}


\title{Assessment functions for Dilution Data}
\description{
  Assessment functoion.
  Takes an
  \code{\link[Biobase]{exprSet-class}} and returns a list with necessary
  information to create assessment plots.}
\usage{
assessDilution(exprset,method.name=NULL)

}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{exprset}{An \code{\link[Biobase]{exprSet-class}} containing
     exrpession measures for 
    Affymetrix's spike-in experiment.}
  \item{method.name}{Name of expression measure being assessed.}
}
\details{
  \code{assessDilution} performs the assessment for the plots related to
  Dilution (Figures 2, 3, 4b)
}
\value{
  Lists with the necessary information to make the Figures.
}
\author{Rafael A. Irizarry}

\keyword{manip}



\eof
\name{assessSD}
\alias{assessSD}


\title{SD Assessment functions}
\description{
  Assessment function for standard deviation estimates.
  Takes a dilution data
  \code{\link[Biobase]{exprSet-class}} and returns a list with necessary
  information to create assessment plot.}
\usage{
assessSD(exprset,method.name=NULL,logx=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{exprset}{An \code{\link[Biobase]{exprSet-class}} containing
     exrpession measures for 
    Affymetrix's spike-in experiment.}
  \item{method.name}{Name of expression measure being assessed.}
  \item{logx}{Logical. If \code{TRUE} expression is logged for plot. See details.}
}
\details{
  \code{assessSD} does the assessment for Figure 7. This requires the
  \code{exprSet} to have standard error estaimtes for the expression
  measure. Some expression (such as dChip) will have SEs for the
  original scale. Others, like RMA will have them for the log scale. For
  orignal scales, making \code{logx=TRUE} is recommended.
}
\value{
  Lists with the necessary information to make the Figures.
}
\author{Rafael A. Irizarry}

\keyword{manip}



\eof
\name{assessSpikeIn}
\alias{assessSpikeIn}
\alias{assessFC}
\alias{assessFC2}
\alias{assessMA}
\alias{assessSignal}

\title{Assessment functions for Spike In Data}
\description{
  These functions are assessment functoions.
  Each takes an
  \code{\link[Biobase]{exprSet-class}} and returns a list with necessary
  information to create assessment plots.}
\usage{
assessSpikeIn(s,method.name=NULL,verbose=TRUE)

assessMA(exprset,method.name=NULL)
assessSignal(exprset,method.name=NULL)
assessFC(exprset,method.name=NULL)
assessFC2(exprset,method.name=NULL)

}
%- maybe also `usage' for other objects documented here.
\arguments{
    \item{s}{An \code{\link[Biobase]{exprSet-class}} containing
     exrpession measures for 
    Affymetrix's spike-in experiment.}
  \item{exprset}{An \code{\link[Biobase]{exprSet-class}} containing
     exrpession measures for 
    Affymetrix's spike-in experiment.}
  \item{method.name}{Name of expression measure being assessed.}
  \item{verbose}{logical. If \code{TRUE} show messages.}
}
\details{
  \code{assessMA} performs the assessment for the MA-plot (Figure 1),
  \code{assessSignal} performs the assessment for signal detection plot
  (Figure 4a), \code{assessFC} perfomrs assessments used by fold-change
  related  plots (Figures 5a, 6a, 6b}. \code{assessFC2} is for the ROC
for genes with nominal fold changes of 2 (Figure
5b). \code{assessSpikeIn} is a wrapper for all these and returns a list
of lists.  
}
\value{
  Lists with the necessary information to make the Figures.
}
\author{Rafael A. Irizarry}

\keyword{manip}



\eof
\name{assessSpikeIn2}
\alias{assessSpikeIn2}
\alias{assessSpikeInSD}
\alias{assessLS}
\alias{assessMA2}

\title{New Assessment functions for Spike In Data}
\description{
  These functions are assessment functoions.
  Each takes an
  \code{\link[Biobase]{exprSet-class}} and returns a list with necessary
  information to create assessment plots.}
\usage{
assessSpikeIn2(s,method.name=NULL,verbose=TRUE)

assessSpikeInSD(exprset,method.name=NULL,span=1/3)
assessLS(exprset,method.name=NULL)
assessMA2(exprset,method.name=NULL)

}
%- maybe also `usage' for other objects documented here.
\arguments{
    \item{s}{An \code{\link[Biobase]{exprSet-class}} containing
     exrpession measures for 
    Affymetrix's spike-in experiment.}
  \item{exprset}{An \code{\link[Biobase]{exprSet-class}} containing
     exrpession measures for 
    Affymetrix's spike-in experiment.}
  \item{method.name}{Name of expression measure being assessed.}
  \item{verbose}{logical. If \code{TRUE} show messages.}
  \item{span}{span used in call to \code{loess}.}
}
\details{
  \code{assessMA2} performs the assessment for the second MA-plot (Figure 1b),
  \code{assessLS} performs the assessment for signal detection plot
  (Figure 4c), \code{assessMA2} also perfomrs assessments used by
  fold-change related  plots (Figures 5c-f}. \code{assessSpikeInSD} is
for the standard deviation assessment of Figure 2b.
\code{assessSpikeIn2} is a wrapper for all these and returns a list
of lists.  
}
\value{
  Lists with the necessary information to make the Figures.
}
\author{Rafael A. Irizarry}

\keyword{manip}




\eof
\name{dilution.phenodata}
\docType{instance}
\alias{dilution.phenodata}
\title{Phenotypic Information for Dilution Study}
\description{
This objact is of class \code{\link[Biobase]{phenoData}} with necessary
  information for the assessemnts.
}
\usage{data(Dilution)}
\format{An object of class \code{\link[Biobase]{phenoData}}}
\source{Two sources of cRNA A (human liver tissue) and B (Central Nervous
System cell line) have been hybridized to human array (HGU95Av2) in a range
of proportions and dilutions. This object described these.

For more information see Irizarry, R.A., et al. (2001)
\url{http://www.biostat.jhsph.edu/~ririzarr/papers/index.html}}


\keyword{datasets}

\eof
\name{exprset.log}
\alias{exprset.log}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Take log base 2 of Expression}
\description{
  Take log base 2 of the expression matrix in an \code{\link[Biobase]{exprSet}}
}
\usage{
exprset.log(exprset)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{exprset}{\code{\link[Biobase]{exprSet}}}
}
\details{
  This functions takes log base 2 of the \code{exprs} slot (expression
  matrix) in an  \code{\link[Biobase]{exprSet}}. Negatives are converted
  to the smallest non-negative entry.
}
\value{
 An \code{\link[Biobase]{exprSet}}
}
\author{Rafael A. Irizarry}
\keyword{manip}

\eof
\name{hgu133a.spikein.phenodata}
\docType{instance}
\alias{hgu133a.spikein.phenodata}
\title{phenotypic information for HGU133A spike in study}
\description{
This objact is of class \code{\link[Biobase]{phenoData}} with necessary
  information for the assessemnts.
}
\usage{data(hgu133a.spikein.phenodata)}
\format{An object of class \code{\link[Biobase]{phenoData}}}
\source{This comes from an experiments where 16 different cRNA
fragments have been added to the hybridization mixture of the GeneChip
arrays at different pM concentrations.  
For more information see Irizarry, R.A., et al. (2001)
\url{http://www.biostat.jhsph.edu/~ririzarr/papers/index.html}}


\keyword{datasets}

\eof
\name{lw.sd.assessment}
\docType{instance}
\alias{lw.sd.assessment}
\title{An example of the result of an SD assessment}
\description{
  The Dilution files were processed with the
  dChip package (using PM-only) and then the
  function \code{\link{assessSD}} was applied. 
}
\usage{data(lw.sd.assessment)}
\format{A list.}


\keyword{datasets}

\eof
\name{mas5.assessment}
\docType{instance}
\alias{mas5.assessment}
\title{An example of the result of an assessment}
\description{
  The Dilution and Spike-in cel files were processed with 
  MAS 5.0 software  and then the
  function \code{\link{assessAll}} was applied. 
}
\usage{data(rma.assessment)}
\format{A list of list.}


\keyword{datasets}

\eof
\name{readin}
\alias{readin}
\alias{read.spikein}
\alias{read.newspikein}
\alias{read.dilution}
\title{Read Expression Date Sets}
\description{
Reads a comma delimeted file containing the expression values of the
dilution and spike-in data sets and creates a \code{\link[Biobase]{exprSet}}
}
\usage{
read.dilution(filename)
read.spikein(filename,cdfName=c("hgu95a","hgu133a")
read.newspikein(filename)
}
\arguments{
  \item{filename}{character containing the filename to be read.}
\item{cdfName}{are we reading data from the hgu95a or hgu133a spike-in experiment?}
}
\details{
 The file to be read must be come delimeted with the first row
 containing the cel fileneames (case sensitive). The first column must
 be the Affymetrix gene identifiers. \code{read.dilution} will put
 things in the right place.

 \code{read.newspikein} is a wrapper to read results from the hgu133a
spikein experiment.}
}
\value{An \code{\link[Biobase]{exprSet}}.
}
\author{Rafael A. Irizarry}
\keyword{manip}

\eof
\name{rma.assessment}
\docType{instance}
\alias{rma.assessment}
\title{An example of the result of an assessment}
\description{
  The Dilution and Spike-in cel files were processed with the
  \code{affy} version 1.0 package rma add-on function and then the
  function \code{\link{assessAll}} was applied. 
}
\usage{data(rma.assessment)}
\format{A list of list.}


\keyword{datasets}

\eof
\name{rma.sd.assessment}
\docType{instance}
\alias{rma.sd.assessment}
\title{An example of the result of an SD assessment}
\description{
  The Dilution files were processed with the
  \code{affy} version 1.0 package rma add-on function and then the
  function \code{\link{assessSD}} was applied. 
}
\usage{data(rma.sd.assessment)}
\format{A list.}


\keyword{datasets}

\eof
\name{spikein.phenodata}
\docType{instance}
\alias{spikein.phenodata}
\title{phenotypic information for spike in study}
\description{
This objact is of class \code{\link[Biobase]{phenoData}} with necessary
  information for the assessemnts.
}
\usage{data(spikein.phenodata)}
\format{An object of class \code{\link[Biobase]{phenoData}}}
\source{This comes from an experiments where 16 different cRNA
fragments have been added to the hybridization mixture of the GeneChip
arrays at different pM concentrations.  
For more information see Irizarry, R.A., et al. (2001)
\url{http://www.biostat.jhsph.edu/~ririzarr/papers/index.html}}


\keyword{datasets}

\eof
