###################################################
### chunk number 1: 
###################################################
  library(segmentSeq)


###################################################
### chunk number 2: 
###################################################
if("snow" %in% installed.packages()[,1])
  {
    library(snow)
    cl <- makeCluster(4, "SOCK")
  } else cl <- NULL


###################################################
### chunk number 3: 
###################################################
  chrlens <- c(1e6, 5e5)

datadir <- system.file("data", package = "segmentSeq")
libfiles <- dir(datadir, pattern = ".txt", full.names = TRUE)
libnames <- c("SL9", "SL10", "SL26", "SL32")
replicates <- c(1,2,1,2)

aD <- processTags(libfiles, replicates, libnames, chrlens, chrs = c(">Chr1", ">Chr2"), header = TRUE)

aD


###################################################
### chunk number 4: 
###################################################
sD <- processAD(aD, maxgaplen = 500, cl = cl)

sD


###################################################
### chunk number 5: 
###################################################
  sDP <- getPriors(sD, type = "Pois", samplesize = 100, perSE = 0.5, maxit = 1000, cl = cl)


###################################################
### chunk number 6: 
###################################################

segD <- segmentSequences(sDP, pcut = 0.1, estimatePriors = FALSE, verbose = TRUE, cl = cl)


###################################################
### chunk number 7: 
###################################################
  segD


###################################################
### chunk number 8: segPlot
###################################################
plotGenome(aD, segD, chr = ">Chr1", limits = c(1, 1e5))


###################################################
### chunk number 9: figSeg
###################################################
plotGenome(aD, segD, chr = ">Chr1", limits = c(1, 1e5))


