###################################################
### chunk number 1: setup
###################################################
options(width=75)
library(oligoClasses)


###################################################
### chunk number 2: initialize_snpset
###################################################
	theCalls <- matrix(sample(1:3, 20, rep=TRUE), nc=2)
	p <- matrix(runif(20), nc=2)
	theConfs <- round(-1000*log2(1-p))
	obj <- new("SnpSet", call=theCalls, callProbability=theConfs)


###################################################
### chunk number 3: accessors_snpset
###################################################
calls(obj)
confs(obj)


###################################################
### chunk number 4: annotation_snpset
###################################################
if(require("genomewidesnp6Crlmm")){
	ids <- c("SNP_A-2131660", "SNP_A-1967418", "SNP_A-1969580", "SNP_A-4263484",
		 "SNP_A-1978185", "SNP_A-4264431", "SNP_A-1980898", "SNP_A-1983139",
		 "SNP_A-4265735", "SNP_A-1995832")
	rownames(theCalls) <- rownames(p) <- rownames(theConfs) <- ids
	obj <- new("SnpSet", call=theCalls, callProbability=theConfs,
		   annotation="genomewidesnp6")
	featureData(obj) <- addFeatureAnnotation(obj)
	fvarLabels(obj)
	isSnp(obj)
	position(obj)
	chromosome(obj)
}


###################################################
### chunk number 5: example_cnSet
###################################################
theCalls <- matrix(2, nc=2, nrow=10)
A <- matrix(sample(1:1000, 20), 10,2)
B <- matrix(sample(1:1000, 20), 10,2)
CA <- matrix(rnorm(20, 1), nrow=10)
CB <- matrix(rnorm(20, 1), nrow=10)
p <- matrix(runif(20), nc=2)
theConfs <- round(-1000*log2(1-p))
obj <- new("CNSet",
	   alleleA=A,
	   alleleB=B,
	   call=theCalls,
	   callProbability=theConfs,
	   CA=CA,
	   CB=CB)


###################################################
### chunk number 6: cnset_accessors
###################################################
calls(obj)
confs(obj)
A(obj)
B(obj)
CA(obj)
CB(obj)


###################################################
### chunk number 7: annotation_cnset eval=FALSE
###################################################
## if(require("genomewidesnp6Crlmm")){
## 	ids <- c("SNP_A-2131660", "SNP_A-1967418", "SNP_A-1969580", "SNP_A-4263484",
## 		 "SNP_A-1978185", "SNP_A-4264431", "SNP_A-1980898", "SNP_A-1983139",
## 		 "SNP_A-4265735", "SNP_A-1995832")
## 	rownames(theCalls) <- rownames(p) <- rownames(theConfs) <- ids
## 	rownames(A) <- rownames(B) <- rownames(CA) <- rownames(CB) <- ids
## 	obj2 <- new("CNSet",
## 		    alleleA=A,
## 		    alleleB=B,
## 		    call=theCalls,
## 		    callProbability=theConfs,
## 		    CA=CA,
## 		    CB=CB, annotation="genomewidesnp6")
## 	fvarLabels(obj2)
## 	## additional accessors
## 	isSnp(obj2)
## 	chromosome(obj2)
## 	position(obj2)
## }


###################################################
### chunk number 8: 
###################################################
toLatex(sessionInfo())


