###################################################
### chunk number 1: make data
###################################################
set.seed(1)
Y <- rnorm(20)
X <- matrix(rnorm(200), 20, 10)
X[,1:3] <- X[,1:3] + Y
colnames(X) <- LETTERS[1:10]


###################################################
### chunk number 2: 
###################################################
library(globaltest)


###################################################
### chunk number 3: options
###################################################
gt.options(trace=FALSE, max.print=45)


###################################################
### chunk number 4: full formula simple
###################################################
gt(Y~1, Y~A+B+C, data = X)


###################################################
### chunk number 5: full formula
###################################################
gt(Y~D, Y~A+B+C+D, data = X)


###################################################
### chunk number 6: summary
###################################################
summary(gt(Y~A, Y~A+B+C, data = X))


###################################################
### chunk number 7: 
###################################################
res <- gt(Y~A, Y~A+B+C, data = X)
p.value(res)
z.score(res)
result(res)
size(res)


###################################################
### chunk number 8:  eval=FALSE
###################################################
## gt(Y~A, ~B+C, data = X)


###################################################
### chunk number 9: 
###################################################
gt(Y~A+B+C, data = X)


###################################################
### chunk number 10: 
###################################################
gt(Y~A, ~., data = X)


###################################################
### chunk number 11: 
###################################################
gt(Y, X)


###################################################
### chunk number 12: null design
###################################################
designA <- cbind(1, X[,"A"])
gt(Y, X, designA)


###################################################
### chunk number 13: poisson
###################################################
P <- rpois(20, lambda=2)
gt(P~A, ~., data=X, model = "Poisson")
gt(P~A, ~., data=X, model = "linear")


###################################################
### chunk number 14: permutations
###################################################
gt(Y,X)
gt(Y,X, permutations=1e4)


###################################################
### chunk number 15: 
###################################################
hist(gt(Y,X, permutations=1e4))


###################################################
### chunk number 16: 
###################################################
A <- X[,"A"]
gt(Y,X,A)
gt(Y,X,~A)


###################################################
### chunk number 17: no intercept
###################################################
gt(Y~0+A, ~ B+C, data = X)


###################################################
### chunk number 18: alternative intercept
###################################################
IC <- rep(1, 20)
gt(Y~0+A, ~ IC+B+C, data = X)


###################################################
### chunk number 19: factors
###################################################
YY <- rnorm(6)
FF <- factor(rep(letters[1:2], 3))
GG <- factor(rep(letters[3:5], 2))
model.matrix(gt(YY ~ FF + GG, x = TRUE))$alternative


###################################################
### chunk number 20: ordered factors
###################################################
GG <- ordered(GG)
model.matrix(gt(YY ~ GG, x = TRUE))$alternative


###################################################
### chunk number 21: weights
###################################################
res <- gt(Y, X)
weights(res)


###################################################
### chunk number 22: 
###################################################
res <- gt(Y,X, standardize=TRUE)
weights(res)


###################################################
### chunk number 23:  eval=FALSE
###################################################
## gt(Y, X[,c("A","A","B")], weights=c(.5,.5,1))
## gt(Y, X[,c("A","B")])


###################################################
### chunk number 24: 
###################################################
gt(Y, X, directional = TRUE)


###################################################
### chunk number 25: 
###################################################
gt(Y~A+B+C,data=X, test.value=c(.2,.2,.2))


###################################################
### chunk number 26: 
###################################################
os <- X[,1:3]%*%c(.2,.2,.2)
gt(Y~offset(os), ~A+B+C, data=X)


###################################################
### chunk number 27: covariates preparation
###################################################
gt(Y~A+B, data=X)
gt(Y~A, data=X)
gt(Y~B, data=X)


###################################################
### chunk number 28: covariates
###################################################
covariates(gt(Y,X))


###################################################
### chunk number 29: covariatesW
###################################################
covariates(gt(Y,X), what="w")


###################################################
### chunk number 30: covariates output
###################################################
res <- covariates(gt(Y,X))
res[1:10]


###################################################
### chunk number 31: covariates leafNodes
###################################################
leafNodes(res, alpha=0.10)


###################################################
### chunk number 32: covariates_zoom
###################################################
covariates(gt(Y,X), zoom=TRUE)


###################################################
### chunk number 33: 
###################################################
subjects(gt(Y,X))


###################################################
### chunk number 34: 
###################################################
subjects(gt(Y,X), what="s", mirror=FALSE)


###################################################
### chunk number 35: subset
###################################################
set <- LETTERS[1:3]
gt(Y,X, subsets = set)


###################################################
### chunk number 36: many sets
###################################################
sets <- list(one=LETTERS[1:3], two=LETTERS[4:6])
gt(Y,X, subsets = sets)


###################################################
### chunk number 37: subsets method
###################################################
res <- gt(Y,X, subsets = sets)
subsets(res)


###################################################
### chunk number 38: many weights
###################################################
wts <- list(up = 1:10, down = 10:1)
gt(Y,X,weights=wts)


###################################################
### chunk number 39: single weight many subsets
###################################################
gt(Y,X, subsets=sets, weights=1:10)


###################################################
### chunk number 40: subsets and weights
###################################################
gt(Y,X, subsets=sets, weights=wts)
gt(Y,X, subsets=sets, weights=list(1:3,7:5))


###################################################
### chunk number 41: alias
###################################################
res <- gt(Y,X, weights=wts, alias = c("one", "two"))
alias(res)
alias(res) <- c("ONE", "TWO")


###################################################
### chunk number 42: sort
###################################################
res[1]
sort(res)


###################################################
### chunk number 43: p.adjust
###################################################
p.adjust(res)
p.adjust(res, "BH")
p.adjust(res, "BY")


###################################################
### chunk number 44: focuslevel set structure
###################################################
level1 <- as.list(LETTERS[1:10])
names(level1) <- letters[1:10]
level2 <- list(abc = LETTERS[1:3], cde  = LETTERS[3:5],
                     fgh = LETTERS[6:8], hij = LETTERS[8:10])
level3 <- list(all = LETTERS[1:10])
dag <- c(level1, level2, level3)


###################################################
### chunk number 45: focus level choice
###################################################
fl <- names(level2)
fl <- findFocus(dag, maxsize=8)


###################################################
### chunk number 46: focus level
###################################################
res <- gt(Y,X)
res <- focusLevel(res, sets = dag, focus=fl)
sort(res)


###################################################
### chunk number 47: focus level leaf nodes
###################################################
leafNodes(res)


###################################################
### chunk number 48: draw
###################################################
draw(res, names=TRUE)


###################################################
### chunk number 49: draw legend eval=FALSE
###################################################
## legend <- draw(res)


###################################################
### chunk number 50: inheritance set structure
###################################################
level1 <- as.list(LETTERS[1:10])
names(level1) <- letters[1:10]
level2 <- list(ab = LETTERS[1:2], cde = LETTERS[3:5], fg = LETTERS[6:7], hij = LETTERS[8:10])
level3 <- list(all = LETTERS[1:10])
tree <- c(level1, level2, level3)


###################################################
### chunk number 51: inheritance
###################################################
res <- gt(Y,X)
resI <- inheritance(res, tree)
resI


###################################################
### chunk number 52: inheritance
###################################################
hc <- hclust(dist(t(X)))
resHC <- inheritance(res, hc)
resHC


###################################################
### chunk number 53: inheritance leaf nodes
###################################################
leafNodes(resI)
leafNodes(resHC)


###################################################
### chunk number 54: inheritance_draw
###################################################
draw(resHC, names=TRUE)


###################################################
### chunk number 55: inheritance covariates eval=FALSE
###################################################
## covariates(res)


###################################################
### chunk number 56: transpose option eval=FALSE
###################################################
## gt.options(transpose=TRUE)


###################################################
### chunk number 57: load Golub
###################################################
library(golubEsets)
data(Golub_Train)


###################################################
### chunk number 58: vsn
###################################################
library(vsn)
exprs(Golub_Train) <- exprs(vsn2(Golub_Train))


###################################################
### chunk number 59: overall
###################################################
gt(ALL.AML, Golub_Train)


###################################################
### chunk number 60: Source
###################################################
gt(ALL.AML ~ Source, Golub_Train)


###################################################
### chunk number 61: transpose option eval=FALSE
###################################################
## gt.options(transpose=TRUE)


###################################################
### chunk number 62: trim option eval=FALSE
###################################################
## gt.options(trim=TRUE)


###################################################
### chunk number 63: gtKEGG
###################################################
gtKEGG(ALL.AML, Golub_Train, id = "04110")


###################################################
### chunk number 64: KEGG organism package
###################################################
eg <- as.list(hu6800ENTREZID)
gtKEGG(ALL.AML, Golub_Train, id="04110", probe2entrez = eg, annotation="org.Hs.eg.db")


###################################################
### chunk number 65: gtKEGG multtest
###################################################
gtKEGG(ALL.AML, Golub_Train, id=c("04110","04210"), multtest="BH")


###################################################
### chunk number 66: testKEGG eval=FALSE
###################################################
## gtKEGG(ALL.AML, Golub_Train)


###################################################
### chunk number 67: gtGO
###################################################
gtGO(ALL.AML, Golub_Train, id="GO:0007049")


###################################################
### chunk number 68: GO organism package
###################################################
eg <- as.list(hu6800ENTREZID)
gtGO(ALL.AML, Golub_Train, id="GO:0007049", probe2entrez = eg, annotation="org.Hs.eg")


###################################################
### chunk number 69: testBP eval=FALSE
###################################################
## gtGO(ALL.AML, Golub_Train, ontology="BP", minsize = 10, maxsize = 500)


###################################################
### chunk number 70: gtGO multtest
###################################################
gtGO(ALL.AML, Golub_Train, id=c("GO:0007049","GO:0006915"), multtest="BH")


###################################################
### chunk number 71: focusGO
###################################################
descendants <- get("GO:0007049", GOBPOFFSPRING)
res <- gtGO(ALL.AML, Golub_Train, id = c("GO:0007049", descendants), multtest = "focus")
leafNodes(res)


###################################################
### chunk number 72: significantGO1 eval=FALSE
###################################################
## draw(res, interactive=TRUE)
## legend <- draw(res)


###################################################
### chunk number 73: significantGO2
###################################################
draw(res)


###################################################
### chunk number 74: getBroadSets eval=FALSE
###################################################
## broad <- getBroadSets("your/path/to/msigdb_v.2.5.xml")


###################################################
### chunk number 75: gtBroad eval=FALSE
###################################################
## gtBroad(ALL.AML, Golub_Train, id = "chr5q33", collection=broad)


###################################################
### chunk number 76: Broad organism package eval=FALSE
###################################################
## eg <- as.list(hu6800ENTREZID)
## gtBroad(ALL.AML, Golub_Train, id = "chr5q33", collection=broad, probe2entrez = eg, annotation="org.Hs.eg.db")


###################################################
### chunk number 77: gtBroad multtest eval=FALSE
###################################################
## gtBroad(ALL.AML, Golub_Train, id=c("chr5q33","chr5q34"), multtest="BH", collection=broad)


###################################################
### chunk number 78: Broad c1 eval=FALSE
###################################################
## gtBroad(ALL.AML, Golub_Train, category="c1", collection=broad)


###################################################
### chunk number 79: KEGG_covariates
###################################################
res <- gtKEGG(ALL.AML, Golub_Train, id = "04110")
features(res, alias=hu6800SYMBOL)


###################################################
### chunk number 80: LeafNodes geneplot
###################################################
ft <- features(res, alias=hu6800SYMBOL)
leafNodes(ft)


###################################################
### chunk number 81: subsets leafNodes eval=FALSE
###################################################
## subsets(leafNodes(ft))


###################################################
### chunk number 82: KEGG_covariates_zoom
###################################################
res <- gtKEGG(ALL.AML, Golub_Train, id = "04110")
features(res, alias=hu6800SYMBOL, zoom=TRUE)


###################################################
### chunk number 83: pdf covariates eval=FALSE
###################################################
## res_all <- gtKEGG(ALL.AML, Golub_Train)
## features(res_all[1:5], pdf="KEGGcov.pdf", alias=hu6800SYMBOL)


###################################################
### chunk number 84: KEGG_subjects
###################################################
res <- gt(ALL.AML, Golub_Train)
subjects(res)


###################################################
### chunk number 85: pdf covariates eval=FALSE
###################################################
## res_all <- gtKEGG(ALL.AML, Golub_Train)
## subjects(res_all[1:25], pdf="KEGGsubj.pdf")


###################################################
### chunk number 86: lungExpression
###################################################
library(lungExpression)
data(michigan)
gt(Surv(TIME..months., death==1), michigan)


###################################################
### chunk number 87: comparative
###################################################
res <- gtKEGG(ALL.AML, Golub_Train, id = "04110")
comparative(res)


