###################################################
### chunk number 1: poisson
###################################################
library(edgeR)
set.seed(101)
n <- 10000
lib.sizes <- c(40000,50000,38000,40000)
p <- runif(n,min=.0001,.001)
mu <- outer(p,lib.sizes)
mu[1:5,3:4]<-mu[1:5,3:4]*8
y <- matrix(rpois(4*n,lambda=mu),nrow=n)
dP <- DGEList(counts=y,group=rep(1:2,each=2),lib.size=lib.sizes)
msP <- de4DGE(dP,doPoisson=TRUE)
dP$pseudo.alt <- msP$pseudo
dP$common.dispersion <- 1e-06 # Set dispersion close to zero to allow exact test for Poisson data
dP$conc <- msP$conc
dP$common.lib.size <- msP$M


###################################################
### chunk number 2: poissonstats
###################################################
de.P <- exactTest(dP)
topTags(de.P)
plotSmear(dP,col=c( rep("blue",5), rep("black",n-5) ))


###################################################
### chunk number 3: setup
###################################################
sessionInfo()


