###################################################
### chunk number 1: f_example
###################################################
    library(SamSPECTRAL)
    data(small_data)
	full <- small
	
    L <- SamSPECTRAL(full,dimension=c(1,2,3),normal.sigma = 200,separation.factor = 0.39)   
	plot(full, pch='.', col= L)


###################################################
### chunk number 2: ReadFiles2
###################################################

    data(small_data)
	full <- small


###################################################
### chunk number 3: ReadFiles2
###################################################
	# Parameters:
    m <- 3000; 
    community.weakness.threshold <-1; precision <- 6; 
	maximum.number.of.clusters <- 30    


###################################################
### chunk number 4: ReadFiles2
###################################################
	for (i.column in 1:dim(full)[2]){#For all columns
		ith.column <- full[,i.column]
		full[,i.column] <- (ith.column-min(ith.column)) /(max(ith.column) - min(ith.column) )  # This is the scaled column.
	}#End for (i.column.
	# Therefore, 	
	space.length <- 1


###################################################
### chunk number 5: f_sampling
###################################################
	# Sample the data and build the communities 
    society <- Building_Communities(full,m, space.length, community.weakness.threshold)
	plot(full[society$representatives, ], pch=20)


###################################################
### chunk number 6: f_small
###################################################
	normal.sigma <- 10
    # Compute conductance between communities
    conductance <- Conductance_Calculation(full, normal.sigma, space.length, society, precision)
    # Compute the eigenspace:
    clust_result <- Civilized_Spectral_Clustering(full, maximum.number.of.clusters, society, conductance,stabilizer=1)    
	eigen.values <- clust_result@eigen.space$values
 	plot(eigen.values[1:50])


###################################################
### chunk number 7: f_large
###################################################
	normal.sigma <- 1000
    # Compute conductance between communities
    conductance <- Conductance_Calculation(full, normal.sigma, space.length, society, precision)
    # Compute the eigenspace:
    clust_result <- Civilized_Spectral_Clustering(full, maximum.number.of.clusters, society, conductance,stabilizer=1)    
	eigen.values <- clust_result@eigen.space$values
 	plot(eigen.values[1:50])


###################################################
### chunk number 8: f_appropriate
###################################################
	normal.sigma <- 250
    # Compute conductance between communities
    conductance <- Conductance_Calculation(full, normal.sigma, space.length, society, precision)
    # Compute the eigenspace:
    clust_result <- Civilized_Spectral_Clustering(full, maximum.number.of.clusters, society, conductance,stabilizer=1)    
	eigen.values <- clust_result@eigen.space$values
 	plot(eigen.values[1:50])


###################################################
### chunk number 9: f_sep1
###################################################
	# Extracting labels:
    labels.for_num.of.clusters <- clust_result@labels.for_num.of.clusters
	number.of.clusters <- clust_result@number.of.clusters
    L33 <- labels.for_num.of.clusters[[number.of.clusters]]
	# Setting septation factor:
	separation.factor <- 0.1
	# post-processing:
    component.of <- Connecting(full, society, conductance, number.of.clusters, labels.for_num.of.clusters, separation.factor)
	# ploting:
    plot(full, pch='.', col= component.of)


###################################################
### chunk number 10: f_sep2
###################################################
	# Setting septation factor:
	separation.factor <- 0.5
	# post-possesing:
    component.of <- Connecting(full, society, conductance, number.of.clusters, labels.for_num.of.clusters, separation.factor)
	# ploting:
    plot(full, pch='.', col= component.of)


