###################################################
### chunk number 1: SetUp Session
###################################################
library(rtracklayer)
session <- browserSession()


###################################################
### chunk number 2: Choose Genome
###################################################
head(ucscGenomes())


###################################################
### chunk number 3: Set Genome
###################################################
genome(session) <- "hg18"


###################################################
### chunk number 4: Check Available Tracks
###################################################
head(trackNames(session))


###################################################
### chunk number 5: Simple Query eval=FALSE
###################################################
## query <- ucscTableQuery(session, "refGene")


###################################################
### chunk number 6: Get Table eval=FALSE
###################################################
## head(getTable(query))


###################################################
### chunk number 7: Access SNPs
###################################################
query <- ucscTableQuery(session, "snp130",
                        GenomicRanges(57795963, 57815592, "chr12"))
head(getTable(query)) 


###################################################
### chunk number 8: SessionInfo
###################################################
sessionInfo()


