###################################################
### chunk number 1: 
###################################################
library(ALL)
data(ALL)
d=exprs(ALL)
d[1:5,1:5]


###################################################
### chunk number 2: 
###################################################
mads=apply(d,1,mad)
d=d[rev(order(mads))[1:5000],]


###################################################
### chunk number 3: 
###################################################
d = sweep(d,1, apply(d,1,median,na.rm=T))


###################################################
### chunk number 4: 
###################################################
library(ConsensusClusterPlus)
title=tempdir()
results = ConsensusClusterPlus(d,maxK=6,reps=50,pItem=0.8,pFeature=1,
title=title,clusterAlg="hc",distance="pearson",seed=1262118388.71279,plot="png")


###################################################
### chunk number 5: 
###################################################
cat(sprintf("\\graphicspath{{%s}}", paste(gsub("[\\]","/",title),"/",sep="")))
cat("\n")


###################################################
### chunk number 6: 
###################################################
#consensusMatrix - the consensus matrix.  
#For .example, the top five rows and columns of results for k=2:
results[[2]][["consensusMatrix"]][1:5,1:5]

#consensusTree - hclust object 
results[[2]][["consensusTree"]]

#consensusClass - the sample classifications
results[[2]][["consensusClass"]][1:5]

#ml - consensus matrix result
#clrs - colors for cluster  


###################################################
### chunk number 7: 
###################################################
icl = calcICL(results,title=title,plot="png")


###################################################
### chunk number 8: 
###################################################
icl[["clusterConsensus"]]


###################################################
### chunk number 9: 
###################################################
icl[["itemConsensus"]][1:5,]


###################################################
### chunk number 10: 
###################################################
cat("\\includegraphics[width=60mm]{consensus001.png}",sep="")


###################################################
### chunk number 11: 
###################################################
cat("\\includegraphics[width=60mm]{consensus002.png}",sep="")
cat("\\includegraphics[width=60mm]{consensus003.png}",sep="")


###################################################
### chunk number 12: 
###################################################
cat("\\includegraphics[width=60mm]{consensus004.png}",sep="")
cat("\\includegraphics[width=60mm]{consensus005.png}",sep="")


###################################################
### chunk number 13: 
###################################################
cat("\\includegraphics[width=60mm]{consensus007.png}",sep="")


###################################################
### chunk number 14: 
###################################################
cat("\\includegraphics[width=60mm]{consensus008.png}",sep="")


###################################################
### chunk number 15: 
###################################################
cat("\\includegraphics[width=60mm]{consensus009.png}",sep="")


###################################################
### chunk number 16: 
###################################################
cat("\\includegraphics[width=60mm]{icl003.png}",sep="")


###################################################
### chunk number 17: 
###################################################
cat("\\includegraphics[width=60mm]{icl001.png}",sep="")


###################################################
### chunk number 18: 
###################################################
#library(cluster)
#dianaHook = function(this_dist,k){
  #tmp = diana(this_dist,diss=TRUE)
  #assignment = cutree(tmp,k)
  #return(assignment)  
#}
#ConsensusClusterPlus(d,clusterAlg="dianaHook",distance="pearson",...)
TRUE


