###################################################
### chunk number 1:  eval=FALSE
###################################################
## scheme.u133p2 <- root.scheme(paste(scmdir,"Scheme_HGU133p2_na28.root",sep="/"))
## data.u133p2   <- root.data(scheme.u133p2, paste(datdir,"HuTissuesU133P2_cel.root",sep="/"))


###################################################
### chunk number 2:  eval=FALSE
###################################################
## data.rma <- rma(data.u133p2, "MixU133P2RMA", filedir=outdir)


###################################################
### chunk number 3:  eval=FALSE
###################################################
## expr.rma <- express(data.u133p2, "U133P2Exprs", filedir=outdir, tmpdir="", update=FALSE,
##             bgcorrect.method="rma", bgcorrect.select="none", bgcorrect.option="pmonly:epanechnikov",
##             bgcorrect.params=c(16384), normalize.method="quantile", normalize.select="pmonly", 
##             normalize.option="transcript:together:none", normalize.logbase="0", 
##             normalize.params=c(0.0), summarize.method="medianpolish", summarize.select="pmonly", 
##             summarize.option="transcript", summarize.logbase="log2", summarize.params=c(10, 0.01, 1.0))


###################################################
### chunk number 4:  eval=FALSE
###################################################
## expr  <- validExpr(expr.rma)


###################################################
### chunk number 5:  eval=FALSE
###################################################
## bgrd.rma <- express(data.u133p2, "BgrdRMA", filedir=outdir, tmpdir="", update=FALSE,
##             bgcorrect.method="rma", bgcorrect.select="none", bgcorrect.option="pmonly:epanechnikov",
##             bgcorrect.params=c(16384))


###################################################
### chunk number 6:  eval=FALSE
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.rma))
## datanames <- colnames(validData(bgrd.rma))
## image(bgrd.rma, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])
## image(bgrd.rma, transfo=log2, col=heat.colors(12), names=datanames[4])


###################################################
### chunk number 7:  eval=FALSE
###################################################
## hist(data.u133p2, which="pm")
## hist(bgrd.rma, which="pm")


###################################################
### chunk number 8:  eval=FALSE
###################################################
## boxplot(data.u133p2, which="pm")
## boxplot(bgrd.rma, which="pm")


###################################################
### chunk number 9:  eval=FALSE
###################################################
## bgrd <- validBgrd(bgrd.rma, which="pm")
## data <- validData(bgrd.rma, which="pm")
## boxplot(log2(bgrd), las=2)
## boxplot(log2(data), las=2)


###################################################
### chunk number 10:  eval=FALSE
###################################################
## norm.qu <- express(bgrd.rma, "NormQuan", filedir=outdir, tmpdir="", update=FALSE, 
##            normalize.method="quantile", normalize.select="pmonly", 
##            normalize.option="transcript:together:none", normalize.logbase="0",
##            normalize.params=c(0.0))


###################################################
### chunk number 11:  eval=FALSE
###################################################
## hist(norm.qu, which="pm")
## boxplot(norm.qu, which="pm")


###################################################
### chunk number 12:  eval=FALSE
###################################################
## data <- validData(norm.qu, which="pm")
## plot(log2(data[,1]), log2(data[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(data[,1]), log2(data[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### chunk number 13:  eval=FALSE
###################################################
## expr.mp <- express(norm.qu, "ExprMedpol", filedir=outdir, tmpdir="", update=FALSE, 
##            summarize.method="medianpolish", summarize.select="pmonly", 
##            summarize.option="transcript", summarize.logbase="log2", 
##            summarize.params=c(10, 0.01, 1.0), bufsize=32000)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## hist(expr.mp)
## boxplot(expr.mp) 


###################################################
### chunk number 15:  eval=FALSE
###################################################
## expr  <- validData(expr.mp)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### chunk number 16:  eval=FALSE
###################################################
## bgrd.rma <- express(data.u133p2, "BgrdRMA", filedir=outdir, tmpdir="", update=FALSE,
##             bgcorrect.method="rma", bgcorrect.select="none", bgcorrect.option="pmonly:epanechnikov",
##             bgcorrect.params=c(16384))


###################################################
### chunk number 17:  eval=FALSE
###################################################
## bgrd.mas4 <- express(data.u133p2, "BgrdMAS4", filedir=outdir, tmpdir="", update=FALSE, 
##              bgcorrect.method="sector", bgcorrect.select="all", bgcorrect.option="subtractbg",
##              bgcorrect.params=c(0.02, 4, 4, 0))


###################################################
### chunk number 18:  eval=FALSE
###################################################
## bgrd.mas <- express(data.u133p2, "BgrdMAS8x8", filedir=outdir, tmpdir="", update=FALSE, 
##             bgcorrect.method="sector", bgcorrect.select="both", bgcorrect.option="correctbg",
##             bgcorrect.params=c(0.02, 8, 8, 3, 0.5))


###################################################
### chunk number 19:  eval=FALSE
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.mas4))
## image(bgrd.mas4, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])
## bgrdnames <- colnames(validBgrd(bgrd.mas))
## image(bgrd.mas, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])


###################################################
### chunk number 20:  eval=FALSE
###################################################
## bgrd.mas5 <- express(data.u133p2, "BgrdMAS5", filedir=outdir, tmpdir="", update=FALSE, 
##              bgcorrect.method="weightedsector", bgcorrect.select="both", bgcorrect.option="correctbg",
##              bgcorrect.params=c(0.02, 4, 4, 0, 100, 0.5))


###################################################
### chunk number 21:  eval=FALSE
###################################################
## hist(bgrd.mas5, which="both")
## bgrd <- validBgrd(bgrd.mas5)
## boxplot(log2(bgrd), las=2)


###################################################
### chunk number 22:  eval=FALSE
###################################################
## bgrd.mas <- express(data.u133p2, "BgrdMAS5_8x8", filedir=outdir, tmpdir="", update=FALSE, 
##             bgcorrect.method="weightedsector", bgcorrect.select="both", bgcorrect.option="correctbg",
##             bgcorrect.params=c(0.02, 8, 8, 3, 100, 0.5))


###################################################
### chunk number 23:  eval=FALSE
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.mas5))
## image(bgrd.mas5, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])
## bgrdnames <- colnames(validBgrd(bgrd.mas4))
## image(bgrd.mas, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])


###################################################
### chunk number 24:  eval=FALSE
###################################################
## bgrd.gc <- express(data.u133p2, "BgrdGC", filedir=outdir, tmpdir="", update=FALSE, 
##            bgcorrect.method="gccontent", bgcorrect.select="none", bgcorrect.option="attenuatebg",
##            bgcorrect.params=c(0.4, 0.005, -1.0))


###################################################
### chunk number 25:  eval=FALSE
###################################################
## hist(bgrd.gc, which="pm")
## bgrd <- validBgrd(bgrd.gc, which="pm")
## boxplot(log2(bgrd), las=2)


###################################################
### chunk number 26:  eval=FALSE
###################################################
## bgrdnames <- colnames(validBgrd(bgrd.gc))
## image(bgrd.gc, bg=TRUE, transfo=log2, col=heat.colors(12), names=bgrdnames[4])


###################################################
### chunk number 27:  eval=FALSE
###################################################
## norm.qu <- express(bgrd.mas, "NormQuan", filedir=outdir, update=FALSE, 
##            normalize.method="quantile", normalize.select="all", 
##            normalize.option="transcript:together:none",
##            normalize.logbase="0", normalize.params=c(0.0, 1.0))


###################################################
### chunk number 28:  eval=FALSE
###################################################
## norm.mn <- express(bgrd.mas, "NormMean", filedir=outdir, tmpdir="", update=FALSE, 
##            normalize.method="mean", normalize.select="both", normalize.option="transcript:all",
##            normalize.logbase="0", normalize.params=c(0.0, -1))


###################################################
### chunk number 29:  eval=FALSE
###################################################
## norm.md <- express(bgrd.mas, "NormMedian", filedir=outdir, tmpdir="", update=FALSE, 
##            normalize.method="median", normalize.select="pmonly", normalize.option="transcript:all",
##            normalize.logbase="log2", normalize.params=c(500), reference.index=1)


###################################################
### chunk number 30:  eval=FALSE
###################################################
## norm.low <- express(bgrd.mas, "NormLowess", filedir=outdir, tmpdir="", update=FALSE, 
##             normalize.method="lowess", normalize.select="pmonly", normalize.option="transcript:all",
##             normalize.logbase="log2", normalize.params=c(0.67, 3.0, 0.0, 0.0))


###################################################
### chunk number 31:  eval=FALSE
###################################################
## norm.sup <- express(bgrd.mas, "NormSupsmuR2", filedir=outdir, tmpdir="", update=FALSE, 
##             normalize.method="supsmu", normalize.select="pmonly", normalize.option="transcript:all",
##             normalize.logbase="log2", normalize.params=c(0.0, 0.0, 2.0, 0.0))


###################################################
### chunk number 32:  eval=FALSE
###################################################
## hist(norm.sup, which="pm")
## boxplot(norm.sup, which="pm")


###################################################
### chunk number 33:  eval=FALSE
###################################################
## expr.mp <- express(norm.qu, "ExprMedpol", filedir=outdir, update=FALSE, 
##            summarize.method="medianpolish", summarize.select="pmonly", summarize.option="transcript",
##            summarize.logbase="log2", summarize.params=c(10, 0.01, 1.0))


###################################################
### chunk number 34:  eval=FALSE
###################################################
## expr.adf <- express(bgrd.mas, "ExprAvgDif", filedir=outdir, update=FALSE, 
##             summarize.method="avgdiff", summarize.select="none", summarize.option="transcript",
##             summarize.logbase="0", summarize.params=c(3.0))


###################################################
### chunk number 35:  eval=FALSE
###################################################
## expr.tbw <- express(bgrd.mas, "ExprTukey", filedir=outdir, update=FALSE, 
##             summarize.method="tukeybiweight", summarize.select="none", summarize.option="transcript",
##             summarize.logbase="log2", summarize.params=c(0.03, 10.0, 2.0e-20, 5.0, 0.0001, 1.0, 0.5))


###################################################
### chunk number 36:  eval=FALSE
###################################################
## hist(expr.tbw)
## boxplot(expr.tbw) 


###################################################
### chunk number 37:  eval=FALSE
###################################################
## expr  <- validData(expr.tbw)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### chunk number 38:  eval=FALSE
###################################################
## expr.dfw <- express(norm.qu, "ExprDFW", filedir=outdir, update=FALSE, 
##             summarize.method="dfw", summarize.select="pmonly", summarize.option="transcript",
##             summarize.logbase="log2", summarize.params=c(3.0, 1.0, 0.01))


###################################################
### chunk number 39:  eval=FALSE
###################################################
## hist(expr.dfw)
## boxplot(expr.dfw) 


###################################################
### chunk number 40:  eval=FALSE
###################################################
## expr  <- validData(expr.dfw)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### chunk number 41:  eval=FALSE
###################################################
## expr.frm <- express(norm.qu, "ExprFARMS", filedir=outdir, update=FALSE, 
##             summarize.method="farms", summarize.select="pmonly", summarize.option="transcript",
##             summarize.logbase="log2", summarize.params=c(131, 0.5, 0.0, 1.0, 0.00001, 100, 1))


###################################################
### chunk number 42:  eval=FALSE
###################################################
## hist(expr.frm)
## boxplot(expr.frm) 


###################################################
### chunk number 43:  eval=FALSE
###################################################
## expr  <- validData(expr.frm)
## plot(log2(expr[,1]), log2(expr[,2]), xlab="BreastA", ylab="BreastB")
## plot(log2(expr[,1]), log2(expr[,4]), xlab="BreastA", ylab="ProstateA")


###################################################
### chunk number 44:  eval=FALSE
###################################################
## nrxp.mn <- normalize(expr.tbw,  "NrmExpMean", filedir=outdir, update=FALSE, 
##            select="separate", method="mean", option="transcript:all", logbase="0", 
##            refindex=1, refmethod="mean", params=c(0.02, 500))


###################################################
### chunk number 45:  eval=FALSE
###################################################
## hist(nrxp.mn)
## boxplot(nrxp.mn) 


###################################################
### chunk number 46:  eval=FALSE
###################################################
## nrxp.low <- normalize(expr.tbw,  "tmp_NrmExpLow", filedir=outdir, update=FALSE, 
##             select="separate", method="lowess", option="transcript:all", logbase="log2", 
##             refindex=0, refmethod="mean", params=c(0.67, 3, 0.0, 0.0))


###################################################
### chunk number 47:  eval=FALSE
###################################################
## nrxp.sup <- normalize(expr.tbw,  "tmp_NrmExpSupR2", filedir=outdir, update=FALSE, 
##             select="separate", method="supsmu", option="transcript:all", logbase="log2", 
##             refindex=0, refmethod="mean", params=c(0.0, 0.0, 2, 0.0))


