###################################################
### chunk number 1: loadPackage
###################################################
library(flowViz)


###################################################
### chunk number 2: loadData
###################################################
library(flowViz)
data(GvHD)
head(pData(GvHD))


###################################################
### chunk number 3: subsetLattice eval=FALSE
###################################################
## xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD,
##        subset=Patient=="6")


###################################################
### chunk number 4: subsetFlowCore
###################################################
GvHD <- GvHD[pData(GvHD)$Patient==6]


###################################################
### chunk number 5: transform
###################################################
tf <- transformList(from=colnames(GvHD)[3:7], tfun=asinh)
GvHD <- tf %on% GvHD


###################################################
### chunk number 6: simpleRG
###################################################
rgate <- rectangleGate("FSC-H"=c(0, 400),"SSC-H"=c(-50, 300))
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate)


###################################################
### chunk number 7: 
###################################################
jpeg(file="figure1.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 8: threeDRG
###################################################
rgate2 <- rgate * rectangleGate("FL1-H"=c(2, 4))
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate)


###################################################
### chunk number 9: nonSmoothScatter
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate, smooth=FALSE)


###################################################
### chunk number 10: 
###################################################
jpeg(file="figure2.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 11: nonSmoothScatterOutline
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate,
smooth=FALSE, outline=TRUE)


###################################################
### chunk number 12: 
###################################################
jpeg(file="figure3.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 13: nonSmoothScatterOutline
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate2,
smooth=FALSE, outline=TRUE)


###################################################
### chunk number 14: 
###################################################
jpeg(file="figure4.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 15: norm2Filter
###################################################
n2Filter <- norm2Filter("SSC-H", "FSC-H", scale=2, filterId="Lymphocytes")
n2Filter.results <- filter(GvHD, n2Filter)
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=n2Filter.results)


###################################################
### chunk number 16: 
###################################################
jpeg(file="figure5.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 17: curv2Filter
###################################################
c2f <- curv2Filter("FSC-H", "FL4-H", bwFac=1.8)
c2f.results <- filter(GvHD, c2f)
xyplot(`FL4-H` ~ `FSC-H` | Visit, data=GvHD, filter=c2f.results)


###################################################
### chunk number 18: 
###################################################
jpeg(file="figure6.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 19: densityplots
###################################################
densityplot(~ `FSC-H`, GvHD, filter=curv1Filter("FSC-H"))


###################################################
### chunk number 20: 
###################################################
jpeg(file="figure7.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 21: multDensityplots
###################################################
densityplot(~ ., GvHD, channels=c("FSC-H", "SSC-H", "FL1-H"), 
filter=list(curv1Filter("FSC-H"), NULL, rgate2))


###################################################
### chunk number 22: 
###################################################
jpeg(file="figure8.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 23: plotPars1
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate,
       par.settings=list(gate=list(fill="black", alpha=0.2)))


###################################################
### chunk number 24: 
###################################################
jpeg(file="figure9.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 25: plotPars2 eval=FALSE
###################################################
## flowViz.par.set(gate=list(fill="black", alpha=0.2))
## xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate)


###################################################
### chunk number 26: plotPars3
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=rgate,
       smooth=FALSE, par.settings=list(gate=list(col="orange", alpha=0.04,
                                                 pch=20, cex=0.7),
                                       flow.symbol=list(alpha=0.04, pch=20,
                                                        cex=0.7)))


###################################################
### chunk number 27: 
###################################################
jpeg(file="figure10.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 28: plotPars4
###################################################
xyplot(`FL4-H` ~ `FSC-H` | Visit, data=GvHD, filter=c2f.results,
par.settings=list(gate=list(fill=rainbow(10), alpha=0.5, col="transparent")))


###################################################
### chunk number 29: 
###################################################
jpeg(file="figure11.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 30: norm2FilterNames
###################################################
xyplot(`SSC-H` ~ `FSC-H` | Visit, data=GvHD, filter=n2Filter.results,
       names=TRUE, par.settings=list(gate=list(fill="black", alpha=0.2, 
                                               col="transparent"),
                                     gate.text=list(col="darkred", alpha=0.7, cex=0.6)))


###################################################
### chunk number 31: 
###################################################
jpeg(file="figure12.jpg", width=650, height=360)
plot(trellis.last.object())
dev.off()


###################################################
### chunk number 32: parCoord
###################################################
parallel(~ . | Visit, GvHD, filter=n2Filter.results, alpha = 0.01)


###################################################
### chunk number 33: 
###################################################
jpeg(file="figure13.jpg", width=650, height=560)
plot(trellis.last.object())
dev.off()


