###################################################
### chunk number 1: options
###################################################
options(continue=" ")


###################################################
### chunk number 2: 
###################################################
library(multtest)
data(golub)  
table(golub.cl)    


###################################################
### chunk number 3: 
###################################################
tst <- mt.teststat(golub, golub.cl) 


###################################################
### chunk number 4: 
###################################################
library(SSPA)
pd <- pilotData(name="ALL/AML",testStatistics=tst,sampleSizeA=11,sampleSizeB=27)


###################################################
### chunk number 5: 
###################################################
pd


###################################################
### chunk number 6: 
###################################################
layout(matrix(c(1,2),nrow=2))
hist(pd, cex.main=1)
plot(pd, cex.main=1)


###################################################
### chunk number 7: 
###################################################
ss <- sampleSize(pd)
ss


###################################################
### chunk number 8: 
###################################################
plotEffectSize(ss, type='l')


###################################################
### chunk number 9: 
###################################################
layout(matrix(c(1:2), nrow=2))
pwr <- Power(ss, plot = FALSE, samplesizes = c(5, 10, 15, 20), fdr=0.01) 
plot(c(5, 10, 15, 20), pwr, ylim = c(0, 1), type = "b", ylab = "Power", xlab = "Sample size per group") 
legend("bottomright", colnames(pwr), col=c(1:ncol(pwr)), pch=1, lty=1)
pwr <- Power(ss, plot = FALSE, samplesizes = c(5, 10, 15, 20), fdr=c(0.01, 0.05)) 
matplot(c(5, 10, 15, 20), pwr, ylim = c(0, 1), type = "b", pch=1, ylab = "Power", xlab = "Sample size per group")
legend("bottomright", colnames(pwr), col=c(1:ncol(pwr)), pch=1, lty=1)


###################################################
### chunk number 10: 
###################################################
layout(matrix(c(1,2), nrow=1))
ss <- sampleSize(pd, method="Ferreira", pi0=seq(0.05, 0.5, 0.05), doplot=TRUE)
plotEffectSize(ss)


