###################################################
### chunk number 1: 
###################################################
options(width=70)


###################################################
### chunk number 2: 
###################################################
require(Genominator)

options(verbose = FALSE)
N <- 100000 # the number of observations. 
K <- 100    # the number of annotation regions, not less than 10

df <- data.frame(chr = sample(1:16, size = N, replace = TRUE),
                 location = sample(1:1000, size = N, replace = TRUE),
                 strand = sample(c(1L,-1L), size = N, replace = TRUE))
eData <- aggregateExpData(importToExpData(df, filename = "pmy.db", overwrite = TRUE, tablename = "ex_tbl"))

annoData <- data.frame(chr = sample(1:16, size = K, replace = TRUE),
                       strand = sample(c(1, -1), size = K, replace = TRUE),
                       start = (st <- sample(1:1000, size = K, replace = TRUE)),
                       end = st + rpois(K, 75),
                       feature = c("gene", "intergenic")[sample(1:2, size = K, replace = TRUE)])
rownames(annoData) <- paste("elt", 1:K, sep = ".")


###################################################
### chunk number 3: 
###################################################
rp <- Genominator:::makeRegionPlotter(list("track.1" = list(expData = eData, what = "counts")))
args(rp)


###################################################
### chunk number 4: 
###################################################
rp(1, 10, 1000)


###################################################
### chunk number 5: 
###################################################
rp <- Genominator:::makeRegionPlotter(list("track.1" = list(expData = eData, what = "counts",
                             dp = DisplayPars(lwd = .45, color = "grey"))))
rp(1, 400, 500)


###################################################
### chunk number 6: 
###################################################
annoFactory <- Genominator:::makeAnnoFactory.AnnoData(annoData, featureColumnName = "feature", 
                                                      groupColumnName = NULL, idColumnName = NULL,
                                                      dp = DisplayPars("gene" = "blue", 
                                                        "intergenic" = "green"))
rp <- Genominator:::makeRegionPlotter(list("track.1" = list(expData = eData, what = "counts",
                               dp = DisplayPars(lwd=.2, color = "grey")),
                             "track.2" = list(expData = eData, what = "counts", 
                               fx = log2, DisplayPars(lwd=.3, color = "black"))),
                        annoFactory = annoFactory)
rp(annoData[1,"chr"], annoData[1, "start"] - 100, annoData[1, "end"] + 100)


###################################################
### chunk number 7: 
###################################################
require("biomaRt")
mart <- useMart("ensembl", dataset = "scerevisiae_gene_ensembl")
annoFactory <- Genominator:::makeAnnoFactory.Biomart(mart, chrFunction = function(chr) as.roman(chr))

load(system.file("data", "chr1_yeast.rda", package = "Genominator"))
head(chr1_yeast)
yData <- importToExpData(chr1_yeast, filename = "my.db", tablename = "yeast", 
                         overwrite = TRUE)

rp <- Genominator:::makeRegionPlotter(list("track.-" = list(expData = yData, what = c("mRNA_1", "mRNA_2"),
                                             fx = rowMeans, strand = -1,
                                             dp = DisplayPars(lwd=.3, color = "grey"))),
                                      annoFactory = annoFactory)
rp(1, 20000, 50000)


