###################################################
### chunk number 1: load
###################################################
library(BCRANK) 


###################################################
### chunk number 2: loadFasta
###################################################
fastaFile <- system.file("Exfiles/USF1_small.fa", package="BCRANK")


###################################################
### chunk number 3: loadResult
###################################################
data(BCRANKout)


###################################################
### chunk number 4: viewBCRANKresult
###################################################
BCRANKout


###################################################
### chunk number 5: viewTopMotif
###################################################
topMotif <- toptable(BCRANKout,1)
topMotif


###################################################
### chunk number 6: viewWM
###################################################
weightMatrix <- pwm(topMotif, normalize=FALSE)
weightMatrix


###################################################
### chunk number 7: fig1
###################################################
weightMatrixNormalized <- pwm(topMotif, normalize=TRUE)
library(seqLogo)
seqLogo(weightMatrixNormalized)


###################################################
### chunk number 8: fig2
###################################################
plot(topMotif)


###################################################
### chunk number 9: reportSites
###################################################
topConsensus <- as.character(toptable(BCRANKout)[1,"Consensus"])
print(topConsensus)
bindingSites <- matchingSites(fastaFile,topConsensus)
nrSites <- nrow(bindingSites)
cat("Number predicted binding sites:",nrSites,"\n")
print(bindingSites[1:15,])


